/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import js.common.ToolProgressMonitor;
import js.tinyvm.ClassPath;
import js.tinyvm.ClassRecord;
import js.tinyvm.CodeSequence;
import js.tinyvm.ConstantRecord;
import js.tinyvm.ConstantValue;
import js.tinyvm.EntryClassIndex;
import js.tinyvm.ExceptionRecord;
import js.tinyvm.InstanceFieldRecord;
import js.tinyvm.InterfaceMap;
import js.tinyvm.MasterRecord;
import js.tinyvm.MethodRecord;
import js.tinyvm.PrimitiveClassRecord;
import js.tinyvm.RecordTable;
import js.tinyvm.Signature;
import js.tinyvm.SpecialClassConstants;
import js.tinyvm.SpecialSignatureConstants;
import js.tinyvm.StaticFieldRecord;
import js.tinyvm.StaticValue;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.util.HashVector;

public class Binary {
    final RecordTable<WritableData> iEntireBinary = new RecordTable("binary", true, true);
    final RecordTable<WritableData> iStaticStorage = new RecordTable("binary", true, true);
    final MasterRecord iMasterRecord = new MasterRecord(this);
    RecordTable<ClassRecord> iClassTable = new RecordTable("class table", false, true);
    RecordTable<StaticValue> iStaticState = new RecordTable("static state", true, true);
    RecordTable<StaticFieldRecord> iStaticFields = new RecordTable("static fields", true, true);
    RecordTable<ConstantRecord> iConstantTable = new RecordTable("constants", false, true);
    RecordTable<RecordTable<MethodRecord>> iMethodTables = new RecordTable("methods", true, true);
    RecordTable<RecordTable<ExceptionRecord>> iExceptionTables = new RecordTable("exceptions", false, true);
    RecordTable<RecordTable<InstanceFieldRecord>> iInstanceFieldTables = new RecordTable("instance fields", true, true);
    final RecordTable<CodeSequence> iCodeSequences = new RecordTable("code", true, true);
    RecordTable<ConstantValue> iConstantValues = new RecordTable("constant values", true, true);
    final RecordTable<EntryClassIndex> iEntryClassIndices = new RecordTable("entry class indices", true, true);
    final RecordTable<InterfaceMap> iInterfaceMaps = new RecordTable("interface", true, true);
    final HashSet<Signature> iSpecialSignatures = new HashSet();
    final HashMap<String, ClassRecord> iClasses = new HashMap();
    final HashVector<Signature> iSignatures = new HashVector();
    int usedClassCount = 0;
    int markGeneration = 0;
    boolean useAll = false;
    final int[] alignments = new int[]{4, 8, 2, 1};
    int constOpLoads = 0;
    int constNormLoads = 0;
    int constWideLoads = 0;
    int constString = 0;
    int staticOpLoads = 0;
    int staticNormLoads = 0;
    int fieldOpOp = 0;
    int fieldNormOp = 0;
    int interfaceClasses = 0;
    int usedInterfaceClasses = 0;
    int implementedInterfaces = 0;
    int usedImplementedInterfaces = 0;

    public Binary(boolean useAll) {
        this.useAll = useAll;
    }

    public void dump(IByteWriter writer) throws TinyVMException {
        this.iEntireBinary.dump(writer);
    }

    protected void addClassRecord(String className, ClassRecord classRecord) {
        assert (className != null) : "Precondition: className != null";
        assert (classRecord != null) : "Precondition: classRecord != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form";
        this.iClasses.put(className, classRecord);
        this.iClassTable.add(classRecord);
    }

    public boolean hasMain(String className) {
        assert (className != null) : "Precondition: className != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form";
        ClassRecord pRec = this.getClassRecord(className);
        return pRec.hasMethod(new Signature("main", "([Ljava/lang/String;)V"), true);
    }

    public ClassRecord getClassRecord(String className) {
        assert (className != null) : "Precondition: className != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form";
        return this.iClasses.get(className);
    }

    public ClassRecord getClassRecordForArray(ClassRecord elementClass) throws TinyVMException {
        int dims = 1;
        if (elementClass.isArray()) {
            dims += elementClass.getArrayDimension();
        }
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = this.iClassTable.get(pIndex);
            if (pRec.getArrayDimension() != dims || pRec.getArrayElementClass() != elementClass) continue;
            return pRec;
        }
        String sig = "";
        for (int i = 0; i < dims; ++i) {
            sig = sig + "[";
        }
        sig = sig + elementClass.signature();
        return ClassRecord.storeArrayClass(sig, this.iClasses, this.iClassTable, null, this);
    }

    public int getClassIndex(String className) {
        assert (className != null) : "Precondition: className != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form";
        return this.getClassIndex(this.getClassRecord(className));
    }

    public int getClassIndex(ClassRecord classRecord) {
        if (classRecord == null) {
            return -1;
        }
        return this.iClassTable.indexOf(classRecord);
    }

    public void markClassUsed(ClassRecord classRecord, boolean instance) {
        if (instance && !classRecord.instanceUsed()) {
            classRecord.markInstanceUsed();
            ++this.usedClassCount;
        }
        if (!classRecord.used()) {
            classRecord.markUsed();
            ++this.usedClassCount;
        }
    }

    public int getGeneration() {
        return this.markGeneration;
    }

    public ConstantRecord getConstantRecord(int index) {
        assert (index >= 0) : "Precondition: index >= 0";
        return this.iConstantTable.get(index);
    }

    public int getConstantIndex(ConstantRecord constantRecord) {
        if (constantRecord == null) {
            return -1;
        }
        return this.iConstantTable.indexOf(constantRecord);
    }

    public boolean useAll() {
        return this.useAll;
    }

    public static Binary createFromClosureOf(String[] entryClassNames, ClassPath classPath, boolean all) throws TinyVMException {
        Binary result = new Binary(all);
        result.processClasses(entryClassNames, classPath);
        result.processSpecialSignatures();
        result.processConstants();
        result.processMethods();
        result.processFields();
        result.markUsed(entryClassNames);
        result.processOptimizedClasses();
        result.processOptimizedConstants();
        result.processOptimizedMethods();
        result.processOptimizedFields();
        result.processCode(false);
        result.storeComponents();
        result.initOffsets();
        result.processCode(true);
        assert (result != null) : "Postconditon: result != null";
        return result;
    }

    public void processClasses(String[] entryClassNames, ClassPath classPath) throws TinyVMException {
        ClassRecord classRecord;
        String className;
        int i;
        assert (entryClassNames != null) : "Precondition: entryClassNames != null";
        assert (classPath != null) : "Precondition: classPath != null";
        ArrayList<String> pInterfaceMethods = new ArrayList<String>();
        String[] specialClasses = SpecialClassConstants.CLASSES;
        for (i = 0; i < specialClasses.length; ++i) {
            className = specialClasses[i];
            if (className.charAt(0) == '[') {
                ClassRecord.storeArrayClass(className, this.iClasses, this.iClassTable, classPath, this);
                continue;
            }
            if (className.indexOf(47) != -1) {
                this.addClassRecord(className, ClassRecord.getClassRecord(className, classPath, this));
                continue;
            }
            this.addClassRecord(className, PrimitiveClassRecord.getClassRecord(className, this, (byte)i));
        }
        for (i = 0; i < entryClassNames.length; ++i) {
            className = entryClassNames[i];
            classRecord = ClassRecord.getClassRecord(className, classPath, this);
            className = classRecord.getName().replace('.', '/');
            classRecord = ClassRecord.getClassRecord(className, classPath, this);
            entryClassNames[i] = className;
            this.addClassRecord(className, classRecord);
            classRecord.useAllMethods();
            this.iEntryClassIndices.add(new EntryClassIndex(this, className));
        }
        for (int pIndex = 0; pIndex < this.iClassTable.size(); ++pIndex) {
            ClassRecord classRecord2 = this.iClassTable.get(pIndex);
            classRecord2.storeReferredClasses(this.iClasses, this.iClassTable, classPath, pInterfaceMethods);
        }
        int pSize = this.iClassTable.size();
        int pIndex = 0;
        while (pIndex < pSize) {
            classRecord = this.iClassTable.get(pIndex);
            for (int i2 = 0; i2 < pInterfaceMethods.size(); ++i2) {
                classRecord.addUsedMethod(pInterfaceMethods.get(i2));
            }
            classRecord.iIndex = pIndex++;
            classRecord.initFlags();
            classRecord.initParent();
        }
    }

    public void processOptimizedClasses() throws TinyVMException {
        ClassRecord classRecord;
        int pIndex;
        RecordTable<ClassRecord> iNewClassTable = new RecordTable<ClassRecord>("class table", false, true);
        int pSize = this.iClassTable.size();
        for (pIndex = 0; pIndex < SpecialClassConstants.CLASSES.length; ++pIndex) {
            classRecord = this.iClassTable.get(pIndex);
            iNewClassTable.add(classRecord);
        }
        for (pIndex = SpecialClassConstants.CLASSES.length; pIndex < pSize; ++pIndex) {
            classRecord = this.iClassTable.get(pIndex);
            if (!classRecord.isInterface() || !this.useAll() && !classRecord.used()) continue;
            classRecord.storeOptimizedImplementingClasses(iNewClassTable);
        }
        for (pIndex = SpecialClassConstants.CLASSES.length; pIndex < pSize; ++pIndex) {
            classRecord = this.iClassTable.get(pIndex);
            if (!this.useAll() && !classRecord.used()) continue;
            iNewClassTable.add(classRecord);
        }
        this.iClassTable = iNewClassTable;
        pSize = this.iClassTable.size();
        for (pIndex = 0; pIndex < pSize; ++pIndex) {
            classRecord = this.iClassTable.get(pIndex);
            classRecord.initParent();
            if (!classRecord.isInterface()) continue;
            classRecord.storeInterfaceMap(this.iInterfaceMaps);
        }
    }

    public void markUsed(String[] entryClassNames) throws TinyVMException {
        int classCount;
        int pSize = this.iClassTable.size();
        String[] specialClasses = SpecialClassConstants.CLASSES;
        for (int i = 0; i < specialClasses.length; ++i) {
            String className = specialClasses[i];
            ClassRecord classRecord = this.getClassRecord(className);
            classRecord.markUsed();
            classRecord.markInstanceUsed();
        }
        Signature staticInit = new Signature("<clinit>()V");
        Signature runMethod = new Signature("run()V");
        Signature mainMethod = new Signature("main", "([Ljava/lang/String;)V");
        for (int i = 0; i < entryClassNames.length; ++i) {
            ClassRecord classRecord = this.getClassRecord(entryClassNames[i]);
            classRecord.markUsed();
            classRecord.markInstanceUsed();
        }
        do {
            MethodRecord pRec;
            ClassRecord classRecord;
            int pIndex;
            classCount = this.usedClassCount;
            ++this.markGeneration;
            for (pIndex = 0; pIndex < pSize; ++pIndex) {
                classRecord = this.iClassTable.get(pIndex);
                if (!classRecord.used() || !classRecord.instanceUsed()) continue;
                classRecord.addInterfaces(classRecord);
                classRecord.findHiddenMethods();
            }
            for (pIndex = 0; pIndex < pSize; ++pIndex) {
                classRecord = this.iClassTable.get(pIndex);
                if (!classRecord.used()) continue;
                if (classRecord.hasMethod(runMethod, false)) {
                    pRec = classRecord.getMethodRecord(runMethod);
                    classRecord.markMethod(pRec, true);
                }
                if (!classRecord.hasStaticInitializer()) continue;
                pRec = classRecord.getMethodRecord(staticInit);
                classRecord.markMethod(pRec, true);
            }
            for (int i = 0; i < entryClassNames.length; ++i) {
                classRecord = this.getClassRecord(entryClassNames[i]);
                if (!classRecord.hasMethod(mainMethod, true)) continue;
                pRec = classRecord.getMethodRecord(mainMethod);
                classRecord.markMethod(pRec, true);
            }
        } while (classCount != this.usedClassCount);
    }

    public void processSpecialSignatures() {
        for (int i = 0; i < SpecialSignatureConstants.SIGNATURES.length; ++i) {
            Signature pSig = new Signature(SpecialSignatureConstants.SIGNATURES[i]);
            this.iSignatures.addElement(pSig);
            this.iSpecialSignatures.add(pSig);
        }
    }

    public boolean isSpecialSignature(Signature aSig) {
        return this.iSpecialSignatures.contains(aSig);
    }

    public void processConstants() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = this.iClassTable.get(pIndex);
            pRec.storeConstants(this.iConstantTable, this.iConstantValues);
        }
    }

    public void processOptimizedConstants() throws TinyVMException {
        int pSize = this.iConstantTable.size();
        RecordTable<ConstantRecord> iOptConstantTable = new RecordTable<ConstantRecord>("constants", false, true);
        RecordTable<ConstantValue> iOptConstantValues = new RecordTable<ConstantValue>("constant values", true, true);
        for (int align : this.alignments) {
            for (int pIndex = 0; pIndex < pSize; ++pIndex) {
                ConstantRecord pRec = this.iConstantTable.get(pIndex);
                if (pRec.constantValue().getAlignment() != align || !this.useAll() && !pRec.used()) continue;
                iOptConstantTable.add(pRec);
                iOptConstantValues.add(pRec.constantValue());
            }
        }
        this.iConstantTable = iOptConstantTable;
        this.iConstantValues = iOptConstantValues;
    }

    public void processMethods() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord classRecord = this.iClassTable.get(pIndex);
            classRecord.storeMethods(this.iMethodTables, this.iExceptionTables, this.iSignatures, this.useAll());
        }
    }

    public void processOptimizedMethods() throws TinyVMException {
        int pSize = this.iClassTable.size();
        this.iMethodTables = new RecordTable("methods", true, true);
        this.iExceptionTables = new RecordTable("exceptions", false, true);
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord classRecord = this.iClassTable.get(pIndex);
            classRecord.storeOptimizedMethods(this.iMethodTables, this.iExceptionTables, this.iSignatures);
        }
    }

    public void processFields() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = this.iClassTable.get(pIndex);
            pRec.storeFields(this.iInstanceFieldTables, this.iStaticFields, this.iStaticState);
        }
    }

    public void printInterfaces() throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = this.iClassTable.get(pIndex);
            if (!pRec.isInterface() || !pRec.used()) continue;
            System.out.println("Interface: " + pRec.iName + " is implemented by:");
            for (ClassRecord cr : pRec.iImplementedBy) {
                System.out.println("Active class: " + cr.iName + " id " + this.getClassIndex(cr));
            }
        }
    }

    public void processOptimizedFields() throws TinyVMException {
        int pSize = this.iClassTable.size();
        this.iStaticState = new RecordTable("static state", true, true);
        this.iStaticFields = new RecordTable("static fields", true, true);
        this.iInstanceFieldTables = new RecordTable("instance fields", true, true);
        for (int align : this.alignments) {
            for (int pIndex = 0; pIndex < pSize; ++pIndex) {
                ClassRecord pRec = this.iClassTable.get(pIndex);
                pRec.storeOptimizedStaticFields(this.iStaticFields, this.iStaticState, align);
            }
        }
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = this.iClassTable.get(pIndex);
            pRec.storeOptimizedFields(this.iInstanceFieldTables);
        }
    }

    public void processCode(boolean aPostProcess) throws TinyVMException {
        int pSize = this.iClassTable.size();
        for (int pIndex = 0; pIndex < pSize; ++pIndex) {
            ClassRecord pRec = this.iClassTable.get(pIndex);
            pRec.storeCode(this.iCodeSequences, aPostProcess);
        }
    }

    public void storeComponents() {
        this.iEntireBinary.add(this.iMasterRecord);
        this.iEntireBinary.add(this.iClassTable);
        this.iStaticStorage.add(this.iStaticState);
        this.iEntireBinary.add(this.iStaticFields);
        this.iEntireBinary.add(this.iConstantTable);
        this.iEntireBinary.add(this.iMethodTables);
        this.iEntireBinary.add(this.iExceptionTables);
        this.iEntireBinary.add(this.iInstanceFieldTables);
        this.iEntireBinary.add(this.iConstantValues);
        this.iEntireBinary.add(this.iInterfaceMaps);
        this.iEntireBinary.add(this.iEntryClassIndices);
        this.iEntireBinary.add(this.iCodeSequences);
    }

    public void initOffsets() throws TinyVMException {
        this.iEntireBinary.initOffset(0);
        this.iStaticStorage.initOffset(0);
    }

    public void setRunTimeOptions(int opt) {
        this.iMasterRecord.setRunTimeOptions(opt);
    }

    public int getTotalNumMethods() {
        int pTotal = 0;
        int pSize = this.iMethodTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += this.iMethodTables.get(i).size();
        }
        return pTotal;
    }

    public int getTotalNumInstanceFields() {
        int pTotal = 0;
        int pSize = this.iInstanceFieldTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += this.iInstanceFieldTables.get(i).size();
        }
        return pTotal;
    }

    public int getTotalNumExceptionRecords() {
        int pTotal = 0;
        int pSize = this.iExceptionTables.size();
        for (int i = 0; i < pSize; ++i) {
            pTotal += this.iExceptionTables.get(i).size();
        }
        return pTotal;
    }

    public void log(ToolProgressMonitor monitor) throws TinyVMException {
        for (int pIndex = 0; pIndex < this.iClassTable.size(); ++pIndex) {
            ClassRecord pRec = this.iClassTable.get(pIndex);
            monitor.log("Class " + pIndex + ": " + pRec.getName());
        }
        int pSize = this.iMethodTables.size();
        int methodNo = 0;
        for (int i = 0; i < pSize; ++i) {
            RecordTable<MethodRecord> rt = this.iMethodTables.get(i);
            int cnt = rt.size();
            for (int j = 0; j < cnt; ++j) {
                MethodRecord mr = rt.get(j);
                if ((mr.iFlags & 1) == 0) {
                    monitor.log("Method " + methodNo + ": Class: " + mr.iClassRecord.getName() + " Signature: " + this.iSignatures.elementAt(mr.iSignatureId).getImage() + " PC " + mr.getCodeStart() + " Signature id " + mr.iSignatureId);
                } else {
                    monitor.log("Method " + methodNo + ": Class: " + mr.iClassRecord.getName() + " Signature: " + this.iSignatures.elementAt(mr.iSignatureId).getImage() + " Native id " + mr.iSignatureId);
                }
                ++methodNo;
            }
        }
        monitor.log("Master record    : " + this.iMasterRecord.getLength() + " bytes.");
        monitor.log("Class records    : " + this.iClassTable.size() + " (" + this.iClassTable.getLength() + " bytes).");
        monitor.log("Field records    : " + this.getTotalNumInstanceFields() + " (" + this.iInstanceFieldTables.getLength() + " bytes).");
        monitor.log("Static fields    : " + this.iStaticFields.size() + " (" + this.iStaticFields.getLength() + " bytes).");
        monitor.log("Static state     : " + this.iStaticState.size() + " (" + this.iStaticState.getLength() + " bytes).");
        monitor.log("Constant records : " + this.iConstantTable.size() + " (" + this.iConstantTable.getLength() + " bytes).");
        monitor.log("Constant values  : " + this.iConstantValues.size() + " (" + this.iConstantValues.getLength() + " bytes).");
        monitor.log("Method records   : " + this.getTotalNumMethods() + " (" + this.iMethodTables.getLength() + " bytes).");
        monitor.log("Exception records: " + this.getTotalNumExceptionRecords() + " (" + this.iExceptionTables.getLength() + " bytes).");
        monitor.log("Interface maps   : " + this.iInterfaceMaps.size() + " (" + this.iInterfaceMaps.getLength() + " bytes).");
        monitor.log("Code             : " + this.iCodeSequences.size() + " (" + this.iCodeSequences.getLength() + " bytes).");
        monitor.log("Total            : " + this.iEntireBinary.getLength() + " bytes.");
        monitor.log("Run time options : " + this.iMasterRecord.getRunTimeOptions());
        monitor.log("Constant loads   : " + this.constNormLoads + "N " + this.constOpLoads + "O " + this.constWideLoads + "W " + this.constString + "S");
        monitor.log("Static load/store: " + this.staticNormLoads + "N " + this.staticOpLoads + "O");
        monitor.log("Field  load/store: " + this.fieldNormOp + "N " + this.fieldOpOp + "O");
    }
}

