/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import js.common.CLIToolProgressMonitor;
import js.common.ToolProgressMonitor;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMTool;
import js.tinyvm.util.TinyVMCommandLineParser;

public class TinyVM
extends TinyVMTool {
    private TinyVMCommandLineParser fParser = new TinyVMCommandLineParser(true);

    public static void main(String[] args) {
        try {
            TinyVM tinyVM = new TinyVM();
            tinyVM.addProgressMonitor(new CLIToolProgressMonitor());
            tinyVM.start(args);
        }
        catch (TinyVMException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String joinCP(String cp1, String cp2) {
        if (cp1.length() > 0) {
            if (cp2.length() > 0) {
                return cp1 + File.pathSeparatorChar + cp2;
            }
            return cp1;
        }
        return cp2;
    }

    public void start(String[] args) throws TinyVMException {
        assert (args != null) : "Precondition: args != null";
        if (!this.fParser.parseOrHelp(TinyVM.class, args)) {
            return;
        }
        String classpath = this.fParser.getCP();
        String bootclasspath = this.fParser.getBP();
        boolean bigEndian = this.fParser.isBigEndian();
        boolean verbose = this.fParser.isVerbose();
        String output = this.fParser.getOutput();
        boolean all = this.fParser.isAll();
        boolean debug = this.fParser.isDebug();
        int options = this.fParser.getRunTimeOptions();
        String[] classes = this.fParser.getRestArgs();
        this.start(TinyVM.joinCP(bootclasspath, classpath), classes, all, output, bigEndian, debug, options, verbose);
    }

    public void start(String classpath, String[] classes, boolean all, String output, boolean bigEndian, boolean debug, int options, boolean verbose) throws TinyVMException {
        for (ToolProgressMonitor monitor : this._monitors) {
            monitor.setVerbose(verbose);
        }
        OutputStream stream = null;
        try {
            stream = output == null ? System.out : new FileOutputStream(output);
            this.link(classpath, classes, all, stream, bigEndian, options, debug);
        }
        catch (FileNotFoundException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
        finally {
            if (stream instanceof FileOutputStream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new TinyVMException(e);
                }
            }
        }
    }
}

