/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableData;
import js.tinyvm.WritableDataWithOffset;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordTable<T extends WritableData>
extends WritableDataWithOffset {
    private String _name;
    private boolean _duplicates;
    private boolean _align;
    private ArrayList<T> _list;
    private int _length;

    public RecordTable(String name, boolean allowDuplicates, boolean align) {
        assert (name != null) : "Precondition: name != null";
        this._name = name;
        this._duplicates = allowDuplicates;
        this._align = align;
        this._list = new ArrayList();
        this._length = -1;
    }

    public void add(T element) {
        assert (element != null) : "Precondition: element != null";
        if (this._duplicates || !this._list.contains(element)) {
            this._list.add(element);
        }
    }

    public T get(int index) {
        assert (index >= 0 && index < this.size()) : "Precondition: index >= 0 && index < size()";
        WritableData result = (WritableData)this._list.get(index);
        assert (result != null) : "Postconditon: result != null";
        return (T)result;
    }

    public int indexOf(T element) {
        assert (element != null) : "Precondition: element != null";
        return this._list.indexOf(element);
    }

    public Iterator<T> iterator() {
        Iterator<T> result = this._list.iterator();
        assert (result != null) : "Postconditon: result != null";
        return result;
    }

    public int size() {
        return this._list.size();
    }

    @Override
    public void dump(IByteWriter writer) throws TinyVMException {
        assert (writer != null) : "Precondition: writer != null";
        try {
            boolean pDoVerify = true;
            for (WritableData pData : this._list) {
                int pLength = pData.getLength();
                int pPrevSize = writer.offset();
                pData.dump(writer);
                if (!pDoVerify || writer.offset() == pPrevSize + pLength) continue;
                if (pData instanceof RecordTable) {
                    // empty if block
                }
                throw new TinyVMException("Bug RT-1: Written=" + (writer.offset() - pPrevSize) + " Length=" + pLength + " Class=" + pData.getClass().getName());
            }
            if (this._align) {
                IOUtilities.writePadding(writer, 4);
            }
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    @Override
    public int getLength() throws TinyVMException {
        if (this._length == -1) {
            this._length = 0;
            Iterator<T> iter = this._list.iterator();
            while (iter.hasNext()) {
                this._length += ((WritableData)iter.next()).getLength();
            }
            if (this._align) {
                this._length = IOUtilities.adjustedSize(this._length, 4);
            }
        }
        return this._length;
    }

    @Override
    public void initOffset(int startOffset) throws TinyVMException {
        super.initOffset(startOffset);
        for (WritableData element : this._list) {
            if (element instanceof WritableDataWithOffset) {
                ((WritableDataWithOffset)element).initOffset(startOffset);
            }
            startOffset += element.getLength();
        }
    }
}

