/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.util.ArrayList;
import java.util.HashMap;
import js.tinyvm.Binary;
import js.tinyvm.ClassPath;
import js.tinyvm.ClassRecord;
import js.tinyvm.CodeSequence;
import js.tinyvm.ConstantRecord;
import js.tinyvm.ConstantValue;
import js.tinyvm.ExceptionRecord;
import js.tinyvm.InstanceFieldRecord;
import js.tinyvm.MethodRecord;
import js.tinyvm.RecordTable;
import js.tinyvm.Signature;
import js.tinyvm.StaticFieldRecord;
import js.tinyvm.StaticValue;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMType;
import js.tinyvm.util.HashVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveClassRecord
extends ClassRecord {
    ConstantRecord classConstant;

    @Override
    public String getName() {
        return this.iName;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean hasStaticInitializer() {
        return false;
    }

    @Override
    public boolean hasMethod(Signature aSignature, boolean aStatic) {
        return false;
    }

    @Override
    public boolean hasReference() throws TinyVMException {
        return this.isArray() && !this.iArrayElementClass.isPrimitive();
    }

    @Override
    public boolean hasParent() {
        return true;
    }

    @Override
    public ClassRecord getParent() {
        ClassRecord result = this.iBinary.getClassRecord("java.lang.Object".replace('.', '/'));
        assert (result != null) : "Postconditon: result != null";
        return result;
    }

    @Override
    public void storeReferredClasses(HashMap<String, ClassRecord> aClasses, RecordTable<ClassRecord> aClassRecords, ClassPath aClassPath, ArrayList<String> aInterfaceMethods) throws TinyVMException {
    }

    @Override
    public void addUsedMethod(String aRef) {
    }

    @Override
    MethodRecord getInterfaceMethodRecord(Signature aSig) {
        return null;
    }

    @Override
    public StaticFieldRecord getStaticFieldRecord(String aName) {
        return this.getParent().getStaticFieldRecord(aName);
    }

    @Override
    public void storeConstants(RecordTable<ConstantRecord> aConstantTable, RecordTable<ConstantValue> aConstantValues) throws TinyVMException {
        ConstantRecord pRec = new ConstantRecord(this, this.iBinary);
        int idx = aConstantTable.indexOf(pRec);
        if (idx == -1) {
            aConstantTable.add(pRec);
            aConstantValues.add(pRec.constantValue());
            this.classConstant = pRec;
        } else {
            this.classConstant = aConstantTable.get(idx);
        }
    }

    @Override
    public void storeMethods(RecordTable<RecordTable<MethodRecord>> aMethodTables, RecordTable<RecordTable<ExceptionRecord>> aExceptionTables, HashVector<Signature> aSignatures, boolean aAll) throws TinyVMException {
        aMethodTables.add(this.iMethodTable);
    }

    @Override
    public void storeOptimizedMethods(RecordTable<RecordTable<MethodRecord>> aMethodTables, RecordTable<RecordTable<ExceptionRecord>> aExceptionTables, HashVector<Signature> aSignatures) throws TinyVMException {
        aMethodTables.add(this.iMethodTable);
    }

    @Override
    public void storeOptimizedStaticFields(RecordTable<StaticFieldRecord> aStaticFields, RecordTable<StaticValue> aStaticState, int align) throws TinyVMException {
    }

    @Override
    public void storeOptimizedFields(RecordTable<RecordTable<InstanceFieldRecord>> aInstanceFieldTables) throws TinyVMException {
        aInstanceFieldTables.add(this.iInstanceFields);
    }

    @Override
    public void storeFields(RecordTable<RecordTable<InstanceFieldRecord>> aInstanceFieldTables, RecordTable<StaticFieldRecord> aStaticFields, RecordTable<StaticValue> aStaticState) throws TinyVMException {
        aInstanceFieldTables.add(this.iInstanceFields);
    }

    @Override
    public void storeCode(RecordTable<CodeSequence> aCodeSequences, boolean aPostProcess) throws TinyVMException {
    }

    @Override
    public void markMethods() throws TinyVMException {
    }

    @Override
    public void markMethod(MethodRecord pRec, boolean directCall) throws TinyVMException {
    }

    public static ClassRecord getClassRecord(String className, Binary aBinary, byte typ) throws TinyVMException {
        assert (className != null) : "Precondition: aName != null";
        assert (aBinary != null) : "Precondition: aBinary != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form: " + className;
        PrimitiveClassRecord pCR = new PrimitiveClassRecord();
        pCR.iBinary = aBinary;
        pCR.iName = className;
        pCR.iCF = null;
        pCR.iType = TinyVMType.tinyVMType(typ);
        pCR.iNumDims = 0;
        return pCR;
    }

    public static ClassRecord getArrayClassRecord(String className, Binary aBinary, int dims, ClassRecord elem) throws TinyVMException {
        assert (className != null) : "Precondition: aName != null";
        assert (aBinary != null) : "Precondition: aBinary != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form: " + className;
        PrimitiveClassRecord pCR = new PrimitiveClassRecord();
        pCR.iBinary = aBinary;
        pCR.iName = className;
        pCR.iCF = null;
        pCR.iType = TinyVMType.T_OBJECT;
        pCR.iNumDims = dims;
        pCR.iArrayElementClass = elem;
        return pCR;
    }

    @Override
    public int getAllocationSize() throws TinyVMException {
        if (this.isArray()) {
            if (this.iArrayElementClass.isPrimitive()) {
                return this.iArrayElementClass.getAllocationSize();
            }
            return TinyVMType.T_OBJECT.size();
        }
        return this.iType.size();
    }

    @Override
    public void addInterfaces(ClassRecord pUserClass) {
        this.getParent().addInterfaces(pUserClass);
    }

    public ConstantRecord getClassConstant() {
        return this.classConstant;
    }
}

