/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import js.tinyvm.Binary;
import js.tinyvm.ClassRecord;
import js.tinyvm.ConstantRecord;
import js.tinyvm.MethodRecord;
import js.tinyvm.OpCodeConstants;
import js.tinyvm.OpCodeInfo;
import js.tinyvm.Signature;
import js.tinyvm.StaticFieldRecord;
import js.tinyvm.StaticValue;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMType;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;

public class CodeUtilities
implements OpCodeConstants,
OpCodeInfo {
    String iFullName;
    JavaClass iCF;
    Binary iBinary;

    public CodeUtilities(String aMethodName, JavaClass aCF, Binary aBinary) {
        this.iFullName = CodeUtilities.fullMethod(aCF, aMethodName);
        this.iCF = aCF;
        this.iBinary = aBinary;
    }

    ClassRecord getClassRecord(String className) throws TinyVMException {
        ClassRecord ret = this.iBinary.getClassRecord(className);
        if (ret == null) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + className + " from class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        return ret;
    }

    ClassRecord getClassRecord(int aPoolIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aPoolIndex);
        if (!(pEntry instanceof ConstantClass)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Class entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantClass pClassEntry = (ConstantClass)pEntry;
        return this.getClassRecord(pClassEntry.getBytes(this.iCF.getConstantPool()));
    }

    public void exitOnBadOpCode(int aOpCode) throws TinyVMException {
        throw new TinyVMException("Unsupported " + OPCODE_NAME[aOpCode] + " in " + this.iFullName + ".\n" + "The following features/conditions are currently unsupported:\n" + "- Too many locals ( > 255).\n" + "- Too many constants ( > 1024).\n" + "- Too many static fields ( > 1024).\n" + "- Method code too long ( > 64 Kb!).\n" + "");
    }

    public static String fullMethod(JavaClass aCF, String aMethodName) {
        return aCF.getClassName() + ":" + aMethodName;
    }

    int getConstantIndex(ConstantRecord pRecord) throws TinyVMException {
        int pIdx = this.iBinary.getConstantIndex(pRecord);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-2: Didn't find constant " + pRecord.toString() + " of class " + this.iCF.getClassName());
        }
        return pIdx;
    }

    public int processConstantIndex(int aPoolIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aPoolIndex);
        if (!(pEntry instanceof ConstantInteger || pEntry instanceof ConstantFloat || pEntry instanceof ConstantString || pEntry instanceof ConstantDouble || pEntry instanceof ConstantLong || pEntry instanceof ConstantClass)) {
            throw new TinyVMException("Classfile error: LDC-type instruction does not refer to a suitable constant. Class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        ConstantRecord pRecord = new ConstantRecord(this.iCF.getConstantPool(), pEntry, this.iBinary);
        return this.getConstantIndex(pRecord);
    }

    public int processClassIndex(int aPoolIndex) throws TinyVMException {
        ClassRecord pClassRecord = this.getClassRecord(aPoolIndex);
        int pIdx = this.iBinary.getClassIndex(pClassRecord);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + pClassRecord.iName + " from class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        return pIdx;
    }

    public int processArray(int aPoolIndex) throws TinyVMException {
        ClassRecord pClassRecord = this.getClassRecord(aPoolIndex);
        ClassRecord pArray = this.iBinary.getClassRecordForArray(pClassRecord);
        if (pArray == null) {
            throw new TinyVMException("Classfile error: Failed to locate array class for " + pClassRecord.iName + " in class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        int pIdx = this.iBinary.getClassIndex(pArray);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + pClassRecord.iName + " from class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        return pIdx;
    }

    public int processMultiArray(int aPoolIndex) throws TinyVMException {
        ClassRecord pClassRecord = this.getClassRecord(aPoolIndex);
        int pIdx = this.iBinary.getClassIndex(pClassRecord);
        if (pIdx == -1) {
            throw new TinyVMException("Bug CU-3: Didn't find class " + pClassRecord.iName + " from class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        return pIdx;
    }

    StaticFieldRecord getStaticFieldRecord(int aFieldIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aFieldIndex);
        if (!(pEntry instanceof ConstantFieldref)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Fieldref entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantFieldref pFieldEntry = (ConstantFieldref)pEntry;
        String className = pFieldEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Attempt to use a field from a primitive array " + className + " from class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pFieldEntry.getNameAndTypeIndex());
        String pName = cnat.getName(this.iCF.getConstantPool());
        StaticFieldRecord pFieldRecord = pClassRecord.getStaticFieldRecord(pName);
        if (pFieldRecord == null) {
            throw new TinyVMException("Failed to locate static field " + pName + " refrenced via class " + className + " from class " + this.iCF.getClassName());
        }
        return pFieldRecord;
    }

    public void markClass(int aPoolIndex) throws TinyVMException {
        ClassRecord pClassRecord = this.getClassRecord(aPoolIndex);
        this.iBinary.markClassUsed(pClassRecord, true);
    }

    public void markArray(int aPoolIndex) throws TinyVMException {
        ClassRecord pClassRecord = this.getClassRecord(aPoolIndex);
        ClassRecord pArray = this.iBinary.getClassRecordForArray(pClassRecord);
        if (pArray == null) {
            throw new TinyVMException("Classfile error: Failed to locate array class for " + pClassRecord.iName + " in class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        this.iBinary.markClassUsed(pArray, true);
    }

    public void markPrimitiveArray(byte type) throws TinyVMException {
        ClassRecord pClassRecord = this.getClassRecord(TinyVMType.tinyVMType(type).cname());
        ClassRecord pArray = this.iBinary.getClassRecordForArray(pClassRecord);
        if (pArray == null) {
            throw new TinyVMException("Classfile error: Failed to locate array class for " + pClassRecord.iName + " in class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        this.iBinary.markClassUsed(pArray, true);
    }

    void markStaticField(int aFieldIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aFieldIndex);
        if (!(pEntry instanceof ConstantFieldref)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Fieldref entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantFieldref pFieldEntry = (ConstantFieldref)pEntry;
        String className = pFieldEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.getClassRecord(className);
        if (pClassRecord == null) {
            return;
        }
        ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pFieldEntry.getNameAndTypeIndex());
        String pName = cnat.getName(this.iCF.getConstantPool());
        this.iBinary.markClassUsed(pClassRecord, false);
        StaticFieldRecord pFieldRecord = pClassRecord.getStaticFieldRecord(pName);
        if (pFieldRecord == null) {
            throw new TinyVMException("Failed to mark/locate static field " + pName + " refrenced via class " + className + " from class " + this.iCF.getClassName());
        }
        this.iBinary.markClassUsed(pFieldRecord.getClassRecord(), false);
        pFieldRecord.markUsed();
    }

    ClassRecord getStaticFieldClass(int aFieldIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aFieldIndex);
        if (!(pEntry instanceof ConstantFieldref)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Fieldref entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantFieldref pFieldEntry = (ConstantFieldref)pEntry;
        String className = pFieldEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Classfile error: Failed to find class " + className);
        }
        return pClassRecord;
    }

    String getStaticFieldName(int aFieldIndex) throws TinyVMException {
        Constant pEntry = this.iCF.getConstantPool().getConstant(aFieldIndex);
        if (!(pEntry instanceof ConstantFieldref)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Fieldref entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantFieldref pFieldEntry = (ConstantFieldref)pEntry;
        String className = pFieldEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Classfile error: Failed to find class " + className);
        }
        ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pFieldEntry.getNameAndTypeIndex());
        String pName = cnat.getName(this.iCF.getConstantPool());
        return pName;
    }

    boolean isWrapperTYPEField(int aFieldIndex) throws TinyVMException {
        ClassRecord pClass = this.getStaticFieldClass(aFieldIndex);
        if (!pClass.isWrapper()) {
            return false;
        }
        String pName = this.getStaticFieldName(aFieldIndex);
        return pName.equals("TYPE");
    }

    void markConstant(int aPoolIndex) throws TinyVMException {
        int constIdx = this.processConstantIndex(aPoolIndex);
        ConstantRecord pRec = this.iBinary.getConstantRecord(constIdx);
        pRec.markUsed();
    }

    int processMethod(int aMethodIndex, boolean aSpecial, boolean aInterface) throws TinyVMException {
        ClassRecord pClassRecord;
        Constant pEntry = this.iCF.getConstantPool().getConstant(aMethodIndex);
        if (!(pEntry instanceof ConstantCP)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_MethodRef or CONSTANT_InterfaceMethodRef got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantCP pMethodEntry = (ConstantCP)pEntry;
        String className = pMethodEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ConstantNameAndType pNT = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pMethodEntry.getNameAndTypeIndex());
        Signature pSig = new Signature(pNT.getName(this.iCF.getConstantPool()), pNT.getSignature(this.iCF.getConstantPool()));
        if (className.startsWith("[")) {
            className = "java/lang/Object";
        }
        if ((pClassRecord = this.getClassRecord(className)) == null) {
            throw new TinyVMException("Bug CU-7: Didn't find class " + className + " from class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        MethodRecord pMethod = aInterface ? pClassRecord.getInterfaceMethodRecord(pSig) : pClassRecord.getVirtualMethodRecord(pSig);
        if (pMethod == null) {
            throw new TinyVMException("Method " + pSig + " not found  in " + className + " interface " + aInterface);
        }
        ClassRecord pTopClass = pMethod.getClassRecord();
        if (aSpecial) {
            int pClassIndex = this.iBinary.getClassIndex(pTopClass);
            assert (pClassIndex != -1 && pClassIndex < 256) : "Check: class index in range";
            int pMethodIndex = pTopClass.getMethodIndex(pMethod);
            assert (pMethodIndex != -1 && pMethodIndex < 255) : "Check: method index in range";
            return pClassIndex << 8 | pMethodIndex & 0xFF;
        }
        int pNumParams = pMethod.getNumParameterWords() - 1;
        assert (pNumParams < 16) : "Check: number of parameters not to high";
        int pSignature = pMethod.getSignatureId();
        assert (pSignature < 4096) : "Check: signature in range";
        return pNumParams << 12 | pSignature;
    }

    MethodRecord findMethod(int aMethodIndex, boolean aSpecial, boolean aInterface) throws TinyVMException {
        ClassRecord pClassRecord;
        Constant pEntry = this.iCF.getConstantPool().getConstant(aMethodIndex);
        if (!(pEntry instanceof ConstantCP)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_MethodRef or CONSTANT_InterfaceMethodRef got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantCP pMethodEntry = (ConstantCP)pEntry;
        String className = pMethodEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ConstantNameAndType pNT = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pMethodEntry.getNameAndTypeIndex());
        Signature pSig = new Signature(pNT.getName(this.iCF.getConstantPool()), pNT.getSignature(this.iCF.getConstantPool()));
        if (className.startsWith("[")) {
            className = "java/lang/Object";
        }
        if ((pClassRecord = this.getClassRecord(className)) == null) {
            throw new TinyVMException("Bug CU-7: Didn't find class " + className + " from class " + this.iCF.getClassName());
        }
        MethodRecord pMethod = aInterface ? pClassRecord.getInterfaceMethodRecord(pSig) : pClassRecord.getVirtualMethodRecord(pSig);
        return pMethod;
    }

    public int genConstantLoad(int aPoolIndex) throws TinyVMException {
        int instruction;
        ConstantRecord pRecord;
        int idx = this.processConstantIndex(aPoolIndex);
        if (idx > 1024) {
            this.exitOnBadOpCode(18);
        }
        if ((pRecord = this.iBinary.getConstantRecord(idx)).constantValue().getAlignment() == 4 && idx < 256) {
            instruction = 18;
            ++this.iBinary.constOpLoads;
        } else {
            instruction = 211 + idx / 256;
            idx %= 256;
            ++this.iBinary.constNormLoads;
            if (pRecord.constantValue().getType() == TinyVMType.T_OBJECT) {
                ++this.iBinary.constString;
            }
        }
        return instruction << 8 | idx;
    }

    public int genStaticAccess(int aPoolIndex, int optInst, int normInst) throws TinyVMException {
        int instruction;
        StaticFieldRecord fieldRec = this.getStaticFieldRecord(aPoolIndex);
        ClassRecord classRec = fieldRec.getClassRecord();
        int classIndex = this.iBinary.getClassIndex(classRec);
        assert (classIndex >= 0 && classIndex <= 255) : "Check: class index in range";
        String name = fieldRec.getName();
        int fieldIndex = classRec.getStaticFieldIndex(name);
        StaticValue valueRec = classRec.getStaticValue(name);
        int offset = classRec.getStaticFieldOffset(name);
        if (valueRec.getAlignment() == 4 && offset / 4 < 256) {
            instruction = optInst;
            offset /= 4;
            ++this.iBinary.staticOpLoads;
        } else {
            if (fieldIndex > 1024) {
                this.exitOnBadOpCode(optInst);
            }
            offset = fieldIndex % 256;
            instruction = normInst + fieldIndex / 256;
            ++this.iBinary.staticNormLoads;
        }
        return instruction << 16 | classIndex << 8 | offset;
    }

    int genFieldAccess(int aFieldIndex, int optInst, int normInst) throws TinyVMException {
        int instruction;
        Constant pEntry = this.iCF.getConstantPool().getConstant(aFieldIndex);
        if (!(pEntry instanceof ConstantFieldref)) {
            throw new TinyVMException("Classfile error: Instruction requiring CONSTANT_Fieldref entry got " + (pEntry == null ? "null" : pEntry.getClass().getName()));
        }
        ConstantFieldref pFieldEntry = (ConstantFieldref)pEntry;
        String className = pFieldEntry.getClass(this.iCF.getConstantPool()).replace('.', '/');
        ClassRecord pClassRecord = this.getClassRecord(className);
        if (pClassRecord == null) {
            throw new TinyVMException("Attempt to use a field from a primitive array " + className + " from class " + this.iCF.getClassName() + " method " + this.iFullName);
        }
        ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(pFieldEntry.getNameAndTypeIndex());
        String pName = cnat.getName(this.iCF.getConstantPool());
        int pOffset = pClassRecord.getInstanceFieldOffset(pName);
        if (pOffset == -1) {
            throw new TinyVMException("Error: Didn't find field " + className + ":" + pName + " from class " + this.iCF.getClassName());
        }
        assert (pOffset <= 4095) : "Check: field offset in range";
        TinyVMType fieldType = TinyVMType.tinyVMTypeFromSignature(cnat.getSignature(this.iCF.getConstantPool()));
        if ((fieldType.type() == 10 || fieldType.type() == 6 || fieldType.type() == 0) && (pOffset & 3) == 0) {
            instruction = optInst;
            ++this.iBinary.fieldOpOp;
        } else {
            instruction = normInst;
            ++this.iBinary.fieldNormOp;
        }
        return instruction << 16 | fieldType.type() << 12 | pOffset;
    }

    static int getAndCopyFourBytesInt(byte[] aCode, int ix, byte[] pOutCode, int ox) {
        int a = 0;
        a |= (aCode[ix + 0] & 0xFF) << 24;
        a |= (aCode[ix + 1] & 0xFF) << 16;
        a |= (aCode[ix + 2] & 0xFF) << 8;
        a |= (aCode[ix + 3] & 0xFF) << 0;
        for (int i = 0; i < 4; ++i) {
            pOutCode[ox + i] = aCode[ix + i];
        }
        return a;
    }

    static int getFourBytesInt(byte[] aCode, int ix) {
        int a = 0;
        a |= (aCode[ix + 0] & 0xFF) << 24;
        a |= (aCode[ix + 1] & 0xFF) << 16;
        a |= (aCode[ix + 2] & 0xFF) << 8;
        return a |= (aCode[ix + 3] & 0xFF) << 0;
    }

    public byte[] processCode(byte[] aCode) throws TinyVMException {
        byte[] pOutCode = new byte[aCode.length];
        int i = 0;
        block21: while (i < aCode.length) {
            pOutCode[i] = aCode[i];
            int pOpCode = pOutCode[i] & 0xFF;
            ++i;
            switch (pOpCode) {
                case 18: {
                    int inst = this.genConstantLoad(aCode[i] & 0xFF);
                    pOutCode[i - 1] = (byte)(inst >> 8);
                    pOutCode[i++] = (byte)(inst & 0xFF);
                    break;
                }
                case 19: {
                    int inst = this.genConstantLoad((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i - 1] = (byte)(inst >> 8);
                    pOutCode[i++] = (byte)(inst & 0xFF);
                    pOutCode[i++] = 0;
                    ++this.iBinary.constWideLoads;
                    break;
                }
                case 20: {
                    int pIdx1 = this.processConstantIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx1 >> 8);
                    pOutCode[i++] = (byte)(pIdx1 & 0xFF);
                    break;
                }
                case 189: {
                    int pIdx5 = this.processArray((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx5 >> 8);
                    pOutCode[i++] = (byte)(pIdx5 & 0xFF);
                    break;
                }
                case 197: {
                    int pIdx2 = this.processMultiArray((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx2 >> 8);
                    pOutCode[i++] = (byte)(pIdx2 & 0xFF);
                    pOutCode[i] = aCode[i];
                    ++i;
                    break;
                }
                case 192: 
                case 193: {
                    int pIdx3 = this.processClassIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    pOutCode[i++] = (byte)(pIdx3 >> 8);
                    pOutCode[i++] = (byte)(pIdx3 & 0xFF);
                    break;
                }
                case 187: {
                    int pIdx4 = this.processClassIndex((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    assert (pIdx4 < 256) : "Check: class index in range";
                    pOutCode[i++] = (byte)(pIdx4 >> 8);
                    pOutCode[i++] = (byte)(pIdx4 & 0xFF);
                    break;
                }
                case 178: {
                    int idx = (aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF;
                    if (this.isWrapperTYPEField(idx)) {
                        idx = this.getConstantIndex(this.getStaticFieldClass(idx).getPrimitiveClass().getClassConstant());
                        pOutCode[i - 1] = -45;
                        pOutCode[i++] = (byte)(idx & 0xFF);
                        pOutCode[i++] = 0;
                        break;
                    }
                    int inst = this.genStaticAccess((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, 178, 203);
                    pOutCode[i - 1] = (byte)(inst >> 16);
                    pOutCode[i++] = (byte)(inst >> 8);
                    pOutCode[i++] = (byte)inst;
                    break;
                }
                case 179: {
                    int inst = this.genStaticAccess((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, 179, 207);
                    pOutCode[i - 1] = (byte)(inst >> 16);
                    pOutCode[i++] = (byte)(inst >> 8);
                    pOutCode[i++] = (byte)inst;
                    break;
                }
                case 180: {
                    int inst = this.genFieldAccess((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, 180, 215);
                    pOutCode[i - 1] = (byte)(inst >> 16);
                    pOutCode[i++] = (byte)(inst >> 8);
                    pOutCode[i++] = (byte)inst;
                    break;
                }
                case 181: {
                    int inst = this.genFieldAccess((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, 181, 216);
                    pOutCode[i - 1] = (byte)(inst >> 16);
                    pOutCode[i++] = (byte)(inst >> 8);
                    pOutCode[i++] = (byte)inst;
                    break;
                }
                case 185: {
                    pOutCode[i - 1] = -74;
                    int pWord3 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false, true);
                    pOutCode[i++] = (byte)(pWord3 >> 8);
                    pOutCode[i++] = (byte)(pWord3 & 0xFF);
                    pOutCode[i++] = 0;
                    pOutCode[i++] = 0;
                    break;
                }
                case 183: 
                case 184: {
                    int pWord4 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, true, false);
                    pOutCode[i++] = (byte)(pWord4 >> 8);
                    pOutCode[i++] = (byte)(pWord4 & 0xFF);
                    break;
                }
                case 182: {
                    int pWord5 = this.processMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false, false);
                    pOutCode[i++] = (byte)(pWord5 >> 8);
                    pOutCode[i++] = (byte)(pWord5 & 0xFF);
                    break;
                }
                case 171: {
                    int oi = i;
                    while (i % 4 != 0) {
                        ++i;
                    }
                    int dft = CodeUtilities.getAndCopyFourBytesInt(aCode, i, pOutCode, oi);
                    int npairs = CodeUtilities.getAndCopyFourBytesInt(aCode, i += 4, pOutCode, oi += 4);
                    i += 4;
                    oi += 4;
                    for (int k = 0; k < npairs; ++k) {
                        int idx = CodeUtilities.getAndCopyFourBytesInt(aCode, i, pOutCode, oi);
                        int off = CodeUtilities.getAndCopyFourBytesInt(aCode, i += 4, pOutCode, oi += 4);
                        i += 4;
                        oi += 4;
                    }
                    while (oi < i) {
                        pOutCode[oi++] = 0;
                    }
                    continue block21;
                }
                case 170: {
                    int oi = i;
                    while (i % 4 != 0) {
                        ++i;
                    }
                    int dft = CodeUtilities.getAndCopyFourBytesInt(aCode, i, pOutCode, oi);
                    int low = CodeUtilities.getAndCopyFourBytesInt(aCode, i += 4, pOutCode, oi += 4);
                    int hig = CodeUtilities.getAndCopyFourBytesInt(aCode, i += 4, pOutCode, oi += 4);
                    i += 4;
                    oi += 4;
                    for (int k = low; k <= hig; ++k) {
                        int idx = CodeUtilities.getAndCopyFourBytesInt(aCode, i, pOutCode, oi);
                        i += 4;
                        oi += 4;
                    }
                    while (oi < i) {
                        pOutCode[oi++] = 0;
                    }
                    continue block21;
                }
                case 196: {
                    if ((aCode[i] & 0xFF) == 132 && aCode[i + 1] == 0) {
                        int k = 0;
                        while (k < 5) {
                            pOutCode[i] = aCode[i];
                            ++k;
                            ++i;
                        }
                        continue block21;
                    }
                }
                case 200: 
                case 201: {
                    this.exitOnBadOpCode(pOpCode);
                    break;
                }
                case 202: {
                    throw new TinyVMException("Invalid opcode detected: " + pOpCode + " " + OPCODE_NAME[pOpCode]);
                }
                default: {
                    int pArgs = OPCODE_ARGS[pOpCode];
                    if (pArgs == -1) {
                        throw new TinyVMException("Bug CU-1: Got " + pOpCode + " in " + this.iFullName + ".");
                    }
                    for (int ctr = 0; ctr < pArgs; ++ctr) {
                        pOutCode[i + ctr] = aCode[i + ctr];
                    }
                    i += pArgs;
                }
            }
        }
        return pOutCode;
    }

    public void processCalls(byte[] aCode, JavaClass aClassFile, Binary aBinary) throws TinyVMException {
        int i = 0;
        block17: while (i < aCode.length) {
            int pOpCode = aCode[i] & 0xFF;
            ++i;
            switch (pOpCode) {
                case 18: {
                    this.markConstant(aCode[i] & 0xFF);
                    ++i;
                    break;
                }
                case 19: 
                case 20: {
                    this.markConstant((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    i += 2;
                    break;
                }
                case 189: {
                    this.markArray((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    i += 2;
                    break;
                }
                case 188: {
                    this.markPrimitiveArray(aCode[i]);
                    ++i;
                    break;
                }
                case 197: {
                    this.markClass((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    i += 3;
                    break;
                }
                case 187: 
                case 192: 
                case 193: {
                    this.markClass((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    i += 2;
                    break;
                }
                case 178: {
                    int idx = (aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF;
                    if (this.isWrapperTYPEField(idx)) {
                        this.getStaticFieldClass(idx).getPrimitiveClass().getClassConstant().markUsed();
                    } else {
                        this.markStaticField((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    }
                    i += 2;
                    break;
                }
                case 179: {
                    this.markStaticField((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF);
                    i += 2;
                    break;
                }
                case 185: {
                    MethodRecord pMeth0 = this.findMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false, true);
                    if (pMeth0 != null) {
                        pMeth0.getClassRecord().markMethod(pMeth0, true);
                    }
                    i += 4;
                    break;
                }
                case 182: {
                    MethodRecord pMeth1 = this.findMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, false, false);
                    if (pMeth1 != null) {
                        pMeth1.getClassRecord().markMethod(pMeth1, true);
                    }
                    i += 2;
                    break;
                }
                case 183: 
                case 184: {
                    MethodRecord pMeth2 = this.findMethod((aCode[i] & 0xFF) << 8 | aCode[i + 1] & 0xFF, true, false);
                    if (pMeth2 != null) {
                        pMeth2.getClassRecord().markMethod(pMeth2, true);
                    }
                    i += 2;
                    break;
                }
                case 171: {
                    while (i % 4 != 0) {
                        ++i;
                    }
                    int dft = CodeUtilities.getFourBytesInt(aCode, i);
                    int npairs = CodeUtilities.getFourBytesInt(aCode, i += 4);
                    i += 4;
                    i += 8 * npairs;
                    break;
                }
                case 170: {
                    while (i % 4 != 0) {
                        ++i;
                    }
                    int dft = CodeUtilities.getFourBytesInt(aCode, i);
                    int low = CodeUtilities.getFourBytesInt(aCode, i += 4);
                    int hig = CodeUtilities.getFourBytesInt(aCode, i += 4);
                    i += 4;
                    for (int k = low; k <= hig; ++k) {
                        i += 4;
                    }
                    continue block17;
                }
                case 196: {
                    if ((aCode[i] & 0xFF) == 132 && aCode[i + 1] == 0) {
                        i += 5;
                        break;
                    }
                }
                case 200: 
                case 201: {
                    this.exitOnBadOpCode(pOpCode);
                    break;
                }
                default: {
                    int pArgs = OPCODE_ARGS[pOpCode];
                    if (pArgs == -1) {
                        throw new TinyVMException("Bug CU-1: Got " + pOpCode + " in " + this.iFullName + ".");
                    }
                    i += pArgs;
                }
            }
        }
    }
}

