/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import js.tinyvm.TinyVMException;
import js.tinyvm.WritableDataWithOffset;
import js.tinyvm.io.IByteWriter;

public class CodeSequence
extends WritableDataWithOffset {
    private byte[] iBytes;
    private static final Logger _logger = Logger.getLogger("TinyVM");

    public void setBytes(byte[] aBytes) {
        this.iBytes = aBytes;
    }

    public int getLength() {
        if (this.iBytes == null) {
            return 0;
        }
        return this.iBytes.length;
    }

    public void dump(IByteWriter aOut) throws TinyVMException {
        try {
            if (this.iBytes == null) {
                _logger.log(Level.WARNING, "Not writing code sequence");
                return;
            }
            aOut.write(this.iBytes);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }
}

