/*
 * Decompiled with CFR 0.152.
 */
package js.tinyvm;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import js.tinyvm.Binary;
import js.tinyvm.ClassPath;
import js.tinyvm.CodeSequence;
import js.tinyvm.ConstantRecord;
import js.tinyvm.ConstantValue;
import js.tinyvm.ExceptionRecord;
import js.tinyvm.InstanceFieldRecord;
import js.tinyvm.InterfaceMap;
import js.tinyvm.MethodRecord;
import js.tinyvm.PrimitiveClassRecord;
import js.tinyvm.RecordTable;
import js.tinyvm.Signature;
import js.tinyvm.StaticFieldRecord;
import js.tinyvm.StaticValue;
import js.tinyvm.TinyVMException;
import js.tinyvm.TinyVMType;
import js.tinyvm.WritableData;
import js.tinyvm.io.IByteWriter;
import js.tinyvm.io.IOUtilities;
import js.tinyvm.util.HashVector;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRecord
implements WritableData {
    int iIndex = -1;
    String iName;
    int iClassSize = -1;
    JavaClass iCF;
    Binary iBinary;
    RecordTable<MethodRecord> iMethodTable = new RecordTable("methods", false, false);
    final RecordTable<InstanceFieldRecord> iInstanceFields = new RecordTable("instance fields", true, false);
    final HashMap<String, StaticValue> iStaticValues = new HashMap();
    final HashMap<String, StaticFieldRecord> iStaticFields = new HashMap();
    HashMap<Signature, MethodRecord> iMethods = new HashMap();
    final ArrayList<String> iUsedMethods = new ArrayList();
    InterfaceMap iInterfaceMap;
    int iParentClassIndex;
    ClassRecord iArrayElementClass;
    int iNumDims;
    TinyVMType iType;
    int iFlags;
    boolean iUseAllMethods = false;
    boolean isInstanceUsed = false;
    HashSet<ClassRecord> iImplementedBy = new HashSet();
    boolean isUsed = false;
    static final String[] wrappers = new String[]{"java/lang/Integer", "java/lang/Boolean", "java/lang/Character", "java/lang/Float", "java/lang/Byte", "java/lang/Short", "java/lang/Double", "java/lang/Long", "java/lang/Void"};
    static final String[] primitive = new String[]{"int", "boolean", "char", "float", "byte", "short", "double", "long", "void"};

    public void useAllMethods() {
        this.iUseAllMethods = true;
    }

    public String getName() {
        return this.iCF.getClassName();
    }

    @Override
    public int getLength() {
        return IOUtilities.adjustedSize(12, 2);
    }

    @Override
    public void dump(IByteWriter aOut) throws TinyVMException {
        try {
            int classIndex = this.iBinary.getClassIndex("java/lang/Class");
            aOut.writeU2(0xFF00 | classIndex);
            int pAllocSize = this.getAllocationSize();
            assert (pAllocSize != 0) : "Check: alloc ok";
            aOut.writeU2(pAllocSize);
            if (this.isArray()) {
                aOut.writeU2(this.iNumDims);
                aOut.writeU2(this.iBinary.getClassIndex(this.iArrayElementClass));
                aOut.writeU1(0);
                aOut.writeU1(0);
            } else if (this.isInterface()) {
                aOut.writeU2(this.iInterfaceMap.getOffset());
                aOut.writeU2(this.iInterfaceMap.getFirst());
                aOut.writeU1(this.iInterfaceMap.getSize());
                aOut.writeU1(0);
            } else {
                int pMethodTableOffset = this.iMethodTable.getOffset();
                aOut.writeU2(pMethodTableOffset);
                aOut.writeU2(this.iInstanceFields.getOffset());
                int pNumMethods = this.iMethodTable.size();
                if (pNumMethods > 255) {
                    throw new TinyVMException("Class " + this.iName + ": No more than " + 255 + " methods expected");
                }
                aOut.writeU1(pNumMethods);
                int pNumFields = this.iInstanceFields.size();
                if (pNumFields > 255) {
                    throw new TinyVMException("Class " + this.iName + ": No more than " + 255 + " fields expected");
                }
                aOut.writeU1(pNumFields);
            }
            aOut.writeU1(this.iParentClassIndex);
            aOut.writeU1(this.iFlags | (this.hasReference() ? 0 : 16));
            IOUtilities.writePadding(aOut, 2);
        }
        catch (IOException e) {
            throw new TinyVMException(e.getMessage(), e);
        }
    }

    public boolean isArray() {
        return this.iNumDims != 0;
    }

    public boolean isInterface() {
        return this.iCF.isInterface();
    }

    public boolean isPrimitive() {
        return this.iType != TinyVMType.T_REFERENCE;
    }

    public boolean hasStaticInitializer() {
        Method[] methods = this.iCF.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("<clinit>")) continue;
            return true;
        }
        return false;
    }

    public boolean hasMethod(Signature aSignature, boolean aStatic) {
        MethodRecord pRec = this.iMethods.get(aSignature);
        if (pRec == null) {
            return false;
        }
        return (pRec.getFlags() & 4) == 0 ^ aStatic;
    }

    public void initFlags() {
        this.iFlags = 0;
        if (this.isArray()) {
            this.iFlags |= 2;
        }
        if (this.isInterface()) {
            this.iFlags |= 8;
        }
        if (this.hasStaticInitializer()) {
            this.iFlags |= 4;
        }
        if (this.isPrimitive()) {
            this.iFlags |= 0x20;
        }
    }

    public int getAllocationSize() throws TinyVMException {
        return this.getClassSize() + 4;
    }

    public int getClassSize() throws TinyVMException {
        if (this.iClassSize != -1) {
            return this.iClassSize;
        }
        this.iClassSize = this.computeClassSize();
        return this.iClassSize;
    }

    public int computeClassSize() throws TinyVMException {
        int pSize = this.hasParent() ? this.getParent().getClassSize() : 0;
        Iterator<InstanceFieldRecord> iter = this.iInstanceFields.iterator();
        while (iter.hasNext()) {
            InstanceFieldRecord pRec = iter.next();
            pSize += pRec.getFieldSize();
        }
        return pSize;
    }

    public boolean hasReference() throws TinyVMException {
        if (this.hasParent() && this.getParent().hasReference()) {
            return true;
        }
        Iterator<InstanceFieldRecord> iter = this.iInstanceFields.iterator();
        while (iter.hasNext()) {
            InstanceFieldRecord pRec = iter.next();
            if (pRec.iType.type() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasParent() {
        return !"java.lang.Object".equals(this.iCF.getClassName());
    }

    public ClassRecord getParent() {
        assert (this.hasParent()) : "Precondition: hasParent()";
        ClassRecord result = this.iBinary.getClassRecord(this.iCF.getSuperclassName().replace('.', '/'));
        assert (result != null) : "Postconditon: result != null";
        return result;
    }

    public void initParent() throws TinyVMException {
        if (this.hasParent()) {
            this.iParentClassIndex = this.iBinary.getClassIndex(this.getParent());
            if (this.iParentClassIndex == -1) {
                throw new TinyVMException("Superclass of " + this.iCF.getClassName() + " not found");
            }
        } else {
            this.iParentClassIndex = 0;
            if (!this.iCF.getClassName().equals("java.lang.Object")) {
                throw new TinyVMException("Expected java.lang.Object: " + this.iCF.getClassName());
            }
        }
    }

    public static String getArrayClassName(String aName) {
        int i = 0;
        while (aName.charAt(i) == '[') {
            ++i;
        }
        TinyVMType typ = TinyVMType.tinyVMTypeFromSignature(aName.substring(i));
        if (typ == TinyVMType.T_OBJECT || typ == TinyVMType.T_REFERENCE) {
            return aName.substring(i + 1, aName.length() - 1);
        }
        return typ.cname();
    }

    static ClassRecord storeArrayClass(String className, HashMap<String, ClassRecord> aClasses, RecordTable<ClassRecord> aClassRecords, ClassPath classPath, Binary iBinary) throws TinyVMException {
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        String elementClassName = ClassRecord.getArrayClassName(className);
        ClassRecord crec = aClasses.get(elementClassName);
        if (crec == null) {
            crec = ClassRecord.getClassRecord(elementClassName, classPath, iBinary);
            aClasses.put(elementClassName, crec);
            aClassRecords.add(crec);
        }
        for (int i = dims - 1; i >= 0; --i) {
            String name = className.substring(i);
            ClassRecord pRec = aClasses.get(name);
            if (pRec == null) {
                pRec = PrimitiveClassRecord.getArrayClassRecord(name, iBinary, dims - i, crec);
                aClasses.put(name, pRec);
                aClassRecords.add(pRec);
            }
            crec = pRec;
        }
        return crec;
    }

    public void storeReferredClasses(HashMap<String, ClassRecord> aClasses, RecordTable<ClassRecord> aClassRecords, ClassPath aClassPath, ArrayList<String> aInterfaceMethods) throws TinyVMException {
        ConstantPool pPool = this.iCF.getConstantPool();
        Constant[] constants = pPool.getConstantPool();
        for (int i = 0; i < constants.length; ++i) {
            Constant pEntry = constants[i];
            if (pEntry instanceof ConstantClass) {
                String pClassName = ((ConstantClass)pEntry).getBytes(pPool);
                if (aClasses.get(pClassName) != null) continue;
                if (pClassName.startsWith("[")) {
                    ClassRecord.storeArrayClass(pClassName, aClasses, aClassRecords, aClassPath, this.iBinary);
                    continue;
                }
                if (aClasses.get(pClassName) != null) continue;
                ClassRecord pRec = ClassRecord.getClassRecord(pClassName, aClassPath, this.iBinary);
                aClasses.put(pClassName, pRec);
                aClassRecords.add(pRec);
                continue;
            }
            if (pEntry instanceof ConstantMethodref) {
                String className = ((ConstantMethodref)pEntry).getClass(pPool).replace('.', '/');
                ClassRecord pClassRec = aClasses.get(className);
                if (pClassRec == null) {
                    if (className.startsWith("[")) {
                        pClassRec = ClassRecord.storeArrayClass(className, aClasses, aClassRecords, aClassPath, this.iBinary);
                    } else {
                        pClassRec = ClassRecord.getClassRecord(className, aClassPath, this.iBinary);
                        aClasses.put(className, pClassRec);
                        aClassRecords.add(pClassRec);
                    }
                }
                ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(((ConstantMethodref)pEntry).getNameAndTypeIndex());
                pClassRec.addUsedMethod(cnat.getName(this.iCF.getConstantPool()) + ":" + cnat.getSignature(this.iCF.getConstantPool()));
                continue;
            }
            if (pEntry instanceof ConstantInterfaceMethodref) {
                ConstantNameAndType cnat = (ConstantNameAndType)this.iCF.getConstantPool().getConstant(((ConstantInterfaceMethodref)pEntry).getNameAndTypeIndex());
                aInterfaceMethods.add(cnat.getName(this.iCF.getConstantPool()) + ":" + cnat.getSignature(this.iCF.getConstantPool()));
                continue;
            }
            if (!(pEntry instanceof ConstantNameAndType)) continue;
            String sig = ((ConstantNameAndType)pEntry).getSignature(this.iCF.getConstantPool());
            if (sig.charAt(0) == '[') {
                ClassRecord.storeArrayClass(sig, aClasses, aClassRecords, aClassPath, this.iBinary);
                continue;
            }
            if (!sig.substring(0, 1).equals("(") || ((ConstantNameAndType)pEntry).getName(this.iCF.getConstantPool()).substring(0, 1).equals("<")) continue;
            aInterfaceMethods.add(((ConstantNameAndType)pEntry).getName(this.iCF.getConstantPool()) + ":" + sig);
        }
    }

    public void addUsedMethod(String aRef) {
        this.iUsedMethods.add(aRef);
    }

    public static String cpEntryId(Constant aEntry) {
        String pClassName = aEntry.getClass().getName();
        int pDotIdx = pClassName.lastIndexOf(46);
        return pDotIdx == -1 ? pClassName : pClassName.substring(pDotIdx + 1);
    }

    MethodRecord getMethodRecord(Signature aSig) {
        return this.iMethods.get(aSig);
    }

    MethodRecord getActualVirtualMethodRecord(Signature aSig) {
        MethodRecord pRec = this.getMethodRecord(aSig);
        if (pRec != null) {
            return pRec;
        }
        if (!this.hasParent()) {
            return null;
        }
        return this.getParent().getActualVirtualMethodRecord(aSig);
    }

    MethodRecord getVirtualMethodRecord(Signature aSig) {
        MethodRecord pRec = this.getInterfaceMethodRecord(aSig);
        if (pRec != null) {
            return pRec;
        }
        if (!this.hasParent()) {
            return null;
        }
        return this.getParent().getVirtualMethodRecord(aSig);
    }

    MethodRecord getInterfaceMethodRecord(Signature aSig) {
        MethodRecord pRec = this.getMethodRecord(aSig);
        if (pRec != null) {
            return pRec;
        }
        String[] interfaces = this.iCF.getInterfaceNames();
        if (interfaces == null) {
            return null;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            ClassRecord pInterfaceRecord = this.iBinary.getClassRecord(interfaces[i].replace('.', '/'));
            pRec = pInterfaceRecord.getInterfaceMethodRecord(aSig);
            if (pRec == null) continue;
            return pRec;
        }
        return null;
    }

    int getMethodIndex(MethodRecord aRecord) {
        return this.iMethodTable.indexOf(aRecord);
    }

    int getApparentInstanceFieldOffset(String aName) throws TinyVMException {
        int pOffset = this.hasParent() ? this.getParent().getClassSize() : 0;
        Iterator<InstanceFieldRecord> iter = this.iInstanceFields.iterator();
        while (iter.hasNext()) {
            InstanceFieldRecord pRec = iter.next();
            if (pRec.getName().equals(aName)) {
                return pOffset;
            }
            pOffset += pRec.getFieldSize();
        }
        if (this.hasParent()) {
            return this.getParent().getApparentInstanceFieldOffset(aName);
        }
        return -1;
    }

    public int getInstanceFieldOffset(String aName) throws TinyVMException {
        int offset = this.getApparentInstanceFieldOffset(aName);
        if (offset < 0) {
            return offset;
        }
        return offset + 4;
    }

    public int getStaticFieldOffset(String aName) throws TinyVMException {
        StaticValue pValue = this.iStaticValues.get(aName);
        if (pValue == null) {
            return -1;
        }
        return pValue.getOffset() - this.iBinary.iStaticState.getOffset();
    }

    public StaticValue getStaticValue(String aName) throws TinyVMException {
        return this.iStaticValues.get(aName);
    }

    public int getStaticFieldIndex(String aName) {
        StaticFieldRecord pRecord = this.iStaticFields.get(aName);
        if (pRecord == null) {
            return -1;
        }
        return this.iBinary.iStaticFields.indexOf(pRecord);
    }

    public StaticFieldRecord getStaticFieldRecord(String aName) {
        StaticFieldRecord pRec = this.iStaticFields.get(aName);
        if (pRec != null) {
            return pRec;
        }
        String[] interfaces = this.iCF.getInterfaceNames();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                ClassRecord pInterfaceRecord = this.iBinary.getClassRecord(interfaces[i].replace('.', '/'));
                pRec = pInterfaceRecord.getStaticFieldRecord(aName);
                if (pRec == null) continue;
                return pRec;
            }
        }
        if (this.hasParent()) {
            return this.getParent().getStaticFieldRecord(aName);
        }
        return null;
    }

    public void storeConstants(RecordTable<ConstantRecord> aConstantTable, RecordTable<ConstantValue> aConstantValues) throws TinyVMException {
        ConstantPool pPool = this.iCF.getConstantPool();
        Constant[] constants = pPool.getConstantPool();
        for (int i = 0; i < constants.length; ++i) {
            ConstantRecord pRec;
            Constant pEntry = constants[i];
            if (!(pEntry instanceof ConstantString) && !(pEntry instanceof ConstantDouble) && !(pEntry instanceof ConstantFloat) && !(pEntry instanceof ConstantInteger) && !(pEntry instanceof ConstantLong) && !(pEntry instanceof ConstantClass) || aConstantTable.indexOf(pRec = new ConstantRecord(pPool, pEntry, this.iBinary)) != -1) continue;
            aConstantTable.add(pRec);
            aConstantValues.add(pRec.constantValue());
        }
    }

    public void storeMethods(RecordTable<RecordTable<MethodRecord>> aMethodTables, RecordTable<RecordTable<ExceptionRecord>> aExceptionTables, HashVector<Signature> aSignatures, boolean aAll) throws TinyVMException {
        Method[] methods = this.iCF.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method pMethod = methods[i];
            Signature pSignature = new Signature(pMethod.getName(), pMethod.getSignature());
            String meth = pMethod.getName() + ":" + pMethod.getSignature();
            if (!aAll && !this.iUseAllMethods && this.iUsedMethods.indexOf(meth) < 0 && !pMethod.getName().substring(0, 1).equals("<") && !meth.equals("run:()V")) continue;
            MethodRecord pMethodRecord = new MethodRecord(pMethod, pSignature, this, this.iBinary, aExceptionTables, aSignatures);
            this.iMethodTable.add(pMethodRecord);
            this.iMethods.put(pSignature, pMethodRecord);
        }
        aMethodTables.add(this.iMethodTable);
    }

    public void storeOptimizedMethods(RecordTable<RecordTable<MethodRecord>> aMethodTables, RecordTable<RecordTable<ExceptionRecord>> aExceptionTables, HashVector<Signature> aSignatures) throws TinyVMException {
        if (this.isInterface()) {
            return;
        }
        RecordTable<MethodRecord> iOptMethodTable = new RecordTable<MethodRecord>("methods", false, false);
        HashMap<Signature, MethodRecord> iOptMethods = new HashMap<Signature, MethodRecord>();
        Iterator<MethodRecord> iter = this.iMethodTable.iterator();
        while (iter.hasNext()) {
            MethodRecord pRec = iter.next();
            if (!this.iBinary.useAll() && !pRec.isCalled()) continue;
            iOptMethodTable.add(pRec);
            iOptMethods.put(aSignatures.elementAt(pRec.iSignatureId), pRec);
            if (pRec.getExceptions() == null) continue;
            aExceptionTables.add(pRec.getExceptions());
        }
        this.iMethodTable = iOptMethodTable;
        this.iMethods = iOptMethods;
        aMethodTables.add(this.iMethodTable);
    }

    public void storeOptimizedStaticFields(RecordTable<StaticFieldRecord> aStaticFields, RecordTable<StaticValue> aStaticState, int align) throws TinyVMException {
        Field[] fields = this.iCF.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field pField = fields[i];
            if (!pField.isStatic()) continue;
            String pName = pField.getName().toString();
            StaticFieldRecord pRec = this.iStaticFields.get(pName);
            StaticValue pValue = this.iStaticValues.get(pName);
            if (pValue.getAlignment() != align || !this.iBinary.useAll() && !pRec.used()) continue;
            aStaticState.add(pValue);
            aStaticFields.add(pRec);
        }
    }

    public void storeOptimizedFields(RecordTable<RecordTable<InstanceFieldRecord>> aInstanceFieldTables) throws TinyVMException {
        aInstanceFieldTables.add(this.iInstanceFields);
    }

    public void storeFields(RecordTable<RecordTable<InstanceFieldRecord>> aInstanceFieldTables, RecordTable<StaticFieldRecord> aStaticFields, RecordTable<StaticValue> aStaticState) throws TinyVMException {
        Field[] fields = this.iCF.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field pField = fields[i];
            if (pField.isStatic()) {
                StaticValue pValue = new StaticValue(pField);
                StaticFieldRecord pRec = new StaticFieldRecord(pField, this);
                String pName = pField.getName().toString();
                assert (!this.iStaticValues.containsKey(pName)) : "Check: value not static";
                this.iStaticValues.put(pName, pValue);
                this.iStaticFields.put(pName, pRec);
                aStaticState.add(pValue);
                aStaticFields.add(pRec);
                continue;
            }
            this.iInstanceFields.add(new InstanceFieldRecord(pField));
        }
        aInstanceFieldTables.add(this.iInstanceFields);
    }

    public void storeCode(RecordTable<CodeSequence> aCodeSequences, boolean aPostProcess) throws TinyVMException {
        Iterator<MethodRecord> iter = this.iMethodTable.iterator();
        while (iter.hasNext()) {
            MethodRecord pRec = iter.next();
            if (aPostProcess) {
                pRec.postProcessCode(aCodeSequences, this.iCF, this.iBinary);
                continue;
            }
            pRec.copyCode(aCodeSequences, this.iCF, this.iBinary);
        }
    }

    public void markMethods() throws TinyVMException {
        Iterator<MethodRecord> iter = this.iMethodTable.iterator();
        while (iter.hasNext()) {
            MethodRecord pRec = iter.next();
            pRec.markCalled(this.iCF, this.iBinary);
        }
    }

    public void markMethod(MethodRecord pRec, boolean directCall) throws TinyVMException {
        if (directCall) {
            this.iBinary.markClassUsed(this, (pRec.getFlags() & 4) == 0);
        }
        pRec.markCalled(this.iCF, this.iBinary);
        if (!this.iImplementedBy.isEmpty()) {
            for (ClassRecord pClass : this.iImplementedBy) {
                MethodRecord pActualMethod = pClass.getActualVirtualMethodRecord(this.iBinary.iSignatures.elementAt(pRec.getSignatureId()));
                if (pActualMethod == null) continue;
                pActualMethod.iClassRecord.markMethod(pActualMethod, false);
            }
        }
    }

    public static ClassRecord getClassRecord(String className, ClassPath aCP, Binary aBinary) throws TinyVMException {
        InputStream pIn;
        assert (className != null) : "Precondition: aName != null";
        assert (aCP != null) : "Precondition: aCP != null";
        assert (aBinary != null) : "Precondition: aBinary != null";
        assert (className.indexOf(46) == -1) : "Precondition: className is in correct form: " + className;
        try {
            pIn = aCP.getInputStream(className);
            assert (pIn != null) : "Check: pIn != null";
        }
        catch (IOException e) {
            throw new TinyVMException("Class " + className.replace('/', '.') + " (file " + className + ".class) not found in CLASSPATH " + aCP);
        }
        ClassRecord pCR = new ClassRecord();
        try {
            pCR.iBinary = aBinary;
            pCR.iName = className;
            BufferedInputStream pBufIn = new BufferedInputStream(pIn, 4096);
            pCR.iCF = new ClassParser((InputStream)pBufIn, className).parse();
            ((InputStream)pBufIn).close();
        }
        catch (Exception e) {
            throw new TinyVMException(e.getMessage(), e);
        }
        pCR.iType = TinyVMType.T_REFERENCE;
        pCR.iNumDims = 0;
        pCR.iArrayElementClass = null;
        return pCR;
    }

    public String toString() {
        return this.iName;
    }

    public int hashCode() {
        return this.iName.hashCode();
    }

    public boolean equals(Object aObj) {
        if (!(aObj instanceof ClassRecord)) {
            return false;
        }
        ClassRecord pOther = (ClassRecord)aObj;
        return pOther.iName.equals(this.iName);
    }

    public void addInterfaces(ClassRecord pUserClass) {
        String[] interfaces = this.iCF.getInterfaceNames();
        if (interfaces == null) {
            return;
        }
        for (int i = 0; i < interfaces.length; ++i) {
            ClassRecord pInterfaceRecord = this.iBinary.getClassRecord(interfaces[i].replace('.', '/'));
            pInterfaceRecord.addInterfaceUser(pUserClass);
            pInterfaceRecord.addInterfaces(pUserClass);
        }
        if (this.hasParent()) {
            this.getParent().addInterfaces(pUserClass);
        }
    }

    public void addInterfaceUser(ClassRecord pRec) {
        if (this.iImplementedBy.contains(pRec)) {
            return;
        }
        this.iImplementedBy.add(pRec);
    }

    public void findHiddenMethods() throws TinyVMException {
        Iterator<MethodRecord> iter = this.iMethodTable.iterator();
        while (iter.hasNext()) {
            MethodRecord pOverridden;
            MethodRecord pRec = iter.next();
            if (!this.hasParent() || (pRec.getFlags() & 4) != 0 || this.iBinary.iSignatures.elementAt(pRec.iSignatureId).getImage().substring(0, 1).equals("<") || (pOverridden = this.getParent().getVirtualMethodRecord(this.iBinary.iSignatures.elementAt(pRec.getSignatureId()))) == null) continue;
            pOverridden.setHiddenBy(pRec);
        }
    }

    public void markUsed() {
        if (!this.isUsed) {
            if (this.hasParent()) {
                this.getParent().markUsed();
            }
            if (this.isArray()) {
                this.iArrayElementClass.markUsed();
            }
        }
        this.isUsed = true;
    }

    public void markInstanceUsed() {
        if (!this.isInstanceUsed) {
            if (this.hasParent()) {
                this.getParent().markInstanceUsed();
            }
            if (this.isArray()) {
                this.iArrayElementClass.markInstanceUsed();
            }
        }
        this.isInstanceUsed = true;
        this.markUsed();
    }

    public boolean used() {
        return this.isUsed;
    }

    public boolean instanceUsed() {
        return this.isInstanceUsed;
    }

    public int getArrayDimension() {
        return this.iNumDims;
    }

    public ClassRecord getArrayElementClass() {
        return this.iArrayElementClass;
    }

    public String signature() {
        String sig = "";
        sig = this.isArray() ? "[" + this.iArrayElementClass.signature() : (this.isPrimitive() ? this.iType.signature() : this.iType.signature() + this.iName + ";");
        return sig;
    }

    private int getWrapperIndex() {
        for (int i = 0; i < wrappers.length; ++i) {
            if (!this.iName.equals(wrappers[i])) continue;
            return i;
        }
        return -1;
    }

    public boolean isWrapper() {
        return this.getWrapperIndex() >= 0;
    }

    public PrimitiveClassRecord getPrimitiveClass() {
        int idx = this.getWrapperIndex();
        if (idx < 0) {
            return null;
        }
        return (PrimitiveClassRecord)this.iBinary.getClassRecord(primitive[idx]);
    }

    public void storeOptimizedImplementingClasses(RecordTable<ClassRecord> aClassRecords) {
        HashSet<ClassRecord> iNewImplementedBy = new HashSet<ClassRecord>();
        for (ClassRecord cr : this.iImplementedBy) {
            if (!cr.used() && !this.iBinary.useAll()) continue;
            iNewImplementedBy.add(cr);
            aClassRecords.add(cr);
        }
        this.iImplementedBy = iNewImplementedBy;
    }

    public void storeInterfaceMap(RecordTable<InterfaceMap> maps) throws TinyVMException {
        if (!this.isInterface()) {
            throw new TinyVMException("Attempt to store an interface map for a non interface class " + this.iName);
        }
        this.iInterfaceMap = new InterfaceMap(this.iBinary, this);
        maps.add(this.iInterfaceMap);
    }
}

