/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.IOException;
import net.sf.antcontrib.cpptasks.TargetHistoryTable;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import net.sf.antcontrib.cpptasks.compiler.ProgressMonitor;

public class CCTaskProgressMonitor
implements ProgressMonitor {
    private ProcessorConfiguration config;
    private TargetHistoryTable history;
    private long lastCommit = -1L;

    public CCTaskProgressMonitor(TargetHistoryTable history) {
        this.history = history;
    }

    public void finish(ProcessorConfiguration config, boolean normal) {
        long current = System.currentTimeMillis();
        if (current - this.lastCommit > 120000L) {
            try {
                this.history.commit();
                this.lastCommit = System.currentTimeMillis();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public void progress(String[] sources) {
        this.history.update(this.config, sources);
        long current = System.currentTimeMillis();
        if (current - this.lastCommit > 120000L) {
            try {
                this.history.commit();
                this.lastCommit = current;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public void start(ProcessorConfiguration config) {
        if (this.lastCommit < 0L) {
            this.lastCommit = System.currentTimeMillis();
        }
        this.config = config;
    }
}

