/*
 * Decompiled with CFR 0.152.
 */
package lejos.robotics.navigation;

import lejos.geom.Point;
import lejos.robotics.Pose;
import lejos.robotics.TachoMotor;
import lejos.robotics.navigation.Pilot;
import lejos.robotics.navigation.TachoPilot;

public class SimpleNavigator {
    private Pose _pose = new Pose();
    private float _distance0 = 0.0f;
    private float _angle0 = 0.0f;
    private boolean _current = false;
    private Pilot pilot;

    public SimpleNavigator(Pilot pilot) {
        this.pilot = pilot;
    }

    public SimpleNavigator(float wheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor, boolean reverse) {
        this.pilot = new TachoPilot(wheelDiameter, trackWidth, leftMotor, rightMotor, reverse);
    }

    public SimpleNavigator(float wheelDiameter, float trackWidth, TachoMotor leftMotor, TachoMotor rightMotor) {
        this.pilot = new TachoPilot(wheelDiameter, trackWidth, leftMotor, rightMotor);
    }

    public float getX() {
        this.updatePose();
        this._current = !this.isMoving();
        return this._pose.getX();
    }

    public float getY() {
        this.updatePose();
        this._current = !this.isMoving();
        return this._pose.getY();
    }

    public float getHeading() {
        this.updatePose();
        this._current = !this.isMoving();
        return this._pose.getHeading();
    }

    public float getAngle() {
        return this.getHeading();
    }

    public void forward() {
        this.updatePose();
        this._current = false;
        this.pilot.forward();
    }

    public void backward() {
        this.updatePose();
        this._current = false;
        this.pilot.backward();
    }

    public void rotateLeft() {
        this.steer(200);
    }

    public void rotateRight() {
        this.steer(-200);
    }

    public Pose getPose() {
        this.updatePose();
        this._current = !this.isMoving();
        return this._pose;
    }

    public void updatePosition() {
        this.updatePose();
    }

    public void setPose(float x, float y, float heading) {
        this._pose.setLocation(new Point(x, y));
        this._pose.setHeading(heading);
    }

    public void setPose(Pose pose) {
        this._pose = pose;
    }

    public void setPosition(float x, float y, float heading) {
        this.setPose(x, y, heading);
    }

    public void setMoveSpeed(float speed) {
        this.pilot.setMoveSpeed(speed);
    }

    public void setTurnSpeed(float speed) {
        this.pilot.setTurnSpeed(speed);
    }

    public void stop() {
        this.pilot.stop();
        this.updatePose();
        this._current = true;
    }

    public boolean isMoving() {
        return this.pilot.isMoving();
    }

    public void travel(float distance) {
        this.travel(distance, false);
    }

    public void travel(float distance, boolean immediateReturn) {
        this.updatePose();
        this._current = false;
        this.pilot.travel(distance, immediateReturn);
    }

    public void rotate(float angle) {
        this.rotate(angle, false);
    }

    public void rotate(float angle, boolean immediateReturn) {
        int turnAngle = Math.round(angle);
        this.updatePose();
        this._current = false;
        this.pilot.rotate(turnAngle, immediateReturn);
    }

    public void rotateTo(float angle) {
        this.rotateTo(angle, false);
    }

    public void rotateTo(float angle, boolean immediateReturn) {
        float turnAngle;
        for (turnAngle = angle - this._pose.getHeading(); turnAngle < -180.0f; turnAngle += 360.0f) {
        }
        while (turnAngle > 180.0f) {
            turnAngle -= 360.0f;
        }
        this.rotate(turnAngle, immediateReturn);
    }

    public void goTo(float x, float y) {
        this.goTo(x, y, false);
    }

    public void goTo(float x, float y, boolean immediateReturn) {
        this.rotateTo(this.angleTo(x, y));
        this.travel(this.distanceTo(x, y), immediateReturn);
    }

    public float distanceTo(float x, float y) {
        this.updatePose();
        this._current = !this.isMoving();
        return this._pose.distanceTo(new Point(x, y));
    }

    public float angleTo(float x, float y) {
        this.updatePose();
        this._current = !this.isMoving();
        return this._pose.angleTo(new Point(x, y));
    }

    public void updatePose() {
        if (this._current) {
            return;
        }
        float distance = this.pilot.getTravelDistance() - this._distance0;
        float turnAngle = this.pilot.getAngle() - this._angle0;
        double dx = 0.0;
        double dy = 0.0;
        double headingRad = Math.toRadians(this._pose.getHeading());
        if ((double)Math.abs(turnAngle) > 0.5) {
            double turnRad = Math.toRadians(turnAngle);
            double radius = (double)distance / turnRad;
            dy = radius * (Math.cos(headingRad) - Math.cos(headingRad + turnRad));
            dx = radius * (Math.sin(headingRad + turnRad) - Math.sin(headingRad));
        } else if ((double)Math.abs(distance) > 0.01) {
            dx = distance * (float)Math.cos(headingRad);
            dy = distance * (float)Math.sin(headingRad);
        }
        this._pose.translate((float)dx, (float)dy);
        this._pose.rotateUpdate(turnAngle);
        this._angle0 = this.pilot.getAngle();
        this._distance0 = this.pilot.getTravelDistance();
    }

    public void arc(float radius) {
        this.pilot.arc(radius);
    }

    public void arc(float radius, int angle) {
        this.arc(radius, angle, false);
    }

    public void arc(float radius, int angle, boolean immediateReturn) {
        this.updatePose();
        this._current = false;
        this.pilot.arc(radius, angle, immediateReturn);
    }

    public void travelArc(float radius, float distance) {
        this.travelArc(radius, distance, false);
    }

    public void travelArc(float radius, float distance, boolean immediateReturn) {
        this.updatePose();
        this.pilot.travelArc(radius, distance, immediateReturn);
    }

    public void steer(int turnRate) {
        this.updatePose();
        this._current = false;
        this.pilot.steer(turnRate);
    }

    public void steer(int turnRate, int angle) {
        this.pilot.steer(turnRate, angle, false);
    }

    public void steer(int turnRate, int angle, boolean immediateReturn) {
        this.updatePose();
        this._current = false;
        this.pilot.steer(turnRate, angle, immediateReturn);
    }
}

