/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import lejos.pc.comm.NXTConnector;

public abstract class RemoteFrame
extends JPanel
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    protected String nxtName;
    protected DataOutputStream dos;
    protected DataInputStream dis;

    public static JFrame openInJFrame(Container content, int width, int height, String title, Color bgColor) {
        JFrame frame = new JFrame(title);
        frame.setBackground(bgColor);
        content.setBackground(bgColor);
        frame.setSize(width, height);
        frame.setContentPane(content);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
        return frame;
    }

    public void paintComponent(Graphics g) {
        this.clear(g);
    }

    protected void clear(Graphics g) {
        super.paintComponent(g);
    }

    public RemoteFrame(String nxtName) throws IOException {
        this.addMouseListener(this);
        this.nxtName = nxtName;
        this.connect();
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void connect() {
        NXTConnector conn = new NXTConnector();
        if (!conn.connectTo(this.nxtName, null, 2)) {
            this.error("NO NXT found");
        }
        System.out.println("Connected to " + this.nxtName);
        this.dis = conn.getDataIn();
        this.dos = conn.getDataOut();
    }

    protected void error(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    public void mouseClicked(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
    }

    protected JButton createButton(String text) {
        JButton button = new JButton(text);
        this.add(button);
        button.addActionListener(this);
        return button;
    }
}

