/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommFactory;
import lejos.pc.comm.NXTCommLoggable;
import lejos.pc.comm.NXTInfo;

public class NXTConnector
extends NXTCommLoggable {
    private DataInputStream dataIn;
    private DataOutputStream dataOut;
    private InputStream is;
    private OutputStream os;
    private NXTInfo nxtInfo;
    private NXTInfo[] nxtInfos;
    private NXTComm nxtCommUSB = null;
    private NXTComm nxtCommBluetooth = null;
    private NXTComm nxtComm = null;
    private boolean debugOn = false;

    public boolean connectTo() {
        return this.connectTo(null, null, 3, 0);
    }

    public boolean connectTo(int mode) {
        return this.connectTo(null, null, 3, mode);
    }

    public boolean connectTo(String nxt, String addr, int protocols) {
        return this.connectTo(nxt, addr, protocols, 0);
    }

    public NXTInfo[] search(String nxt, String addr, int protocols) {
        String name = nxt == null || nxt.length() == 0 ? nxt : "Unknown";
        String searchParam = nxt == null || nxt.length() == 0 || nxt.equals("*") ? null : nxt;
        String searchFor = nxt == null || nxt.length() == 0 ? "any NXT" : nxt;
        Properties props = null;
        this.nxtComm = null;
        this.nxtInfos = new NXTInfo[0];
        this.debug("Protocols = " + protocols);
        this.debug("Search Param = " + searchParam);
        if ((protocols & 1) != 0) {
            try {
                this.nxtComm = this.nxtCommUSB = NXTCommFactory.createNXTComm(1);
            }
            catch (NXTCommException e) {
                this.log("Failed to load USB comms driver: " + e.getMessage());
            }
            if (addr != null && addr.length() > 0) {
                this.log("Using USB device with address = " + addr);
                this.nxtInfo = new NXTInfo(1, name, addr);
                this.nxtInfos = new NXTInfo[1];
                this.nxtInfos[0] = this.nxtInfo;
            } else if (this.nxtComm != null) {
                this.debug("Searching for " + searchFor + " using USB");
                try {
                    this.nxtInfos = this.nxtComm.search(searchParam, 1);
                    if (this.nxtInfos.length == 0) {
                        this.debug((searchParam == null ? "No NXT found using USB: " : searchParam + " not found using USB: ") + "Is the NXT switched on and the USB cable connected?");
                    }
                }
                catch (NXTCommException ex) {
                    this.log("Search Failed: " + ex.getMessage());
                }
            }
        }
        if (this.nxtInfos.length > 0) {
            return this.nxtInfos;
        }
        if ((protocols & 2) != 0) {
            try {
                this.nxtComm = this.nxtCommBluetooth = NXTCommFactory.createNXTComm(2);
            }
            catch (NXTCommException e) {
                this.log("Failed to load Bluetooth comms driver: " + e.getMessage());
                return this.nxtInfos;
            }
            if (addr != null && addr.length() > 0) {
                this.log("Using Bluetooth device with address = " + addr);
                this.nxtInfo = new NXTInfo(2, name, addr);
                this.nxtInfos = new NXTInfo[1];
                this.nxtInfos[0] = this.nxtInfo;
                return this.nxtInfos;
            }
            try {
                props = NXTCommFactory.getNXJCache();
                if (!(props.size() <= 0 || nxt != null && nxt.equals("*"))) {
                    Hashtable<String, String> nxtNames = new Hashtable<String, String>();
                    Enumeration<?> enProps = props.propertyNames();
                    this.debug("Searching cache file for known Bluetooth devices");
                    while (enProps.hasMoreElements()) {
                        String propName = (String)enProps.nextElement();
                        if (!propName.startsWith("NXT_")) continue;
                        String nxtName = propName.substring(4);
                        String nxtAddr = (String)props.get(propName);
                        if (searchParam != null && !nxtName.equals(nxt)) continue;
                        this.debug("Found " + nxtName + " " + nxtAddr + " in cache file");
                        nxtNames.put(nxtName, nxtAddr);
                    }
                    this.debug("Found " + nxtNames.size() + " matching NXTs in cache file");
                    if (nxtNames.size() > 0) {
                        this.nxtInfos = new NXTInfo[nxtNames.size()];
                        Enumeration enNXTs = nxtNames.keys();
                        int i = 0;
                        while (enNXTs.hasMoreElements()) {
                            String ne = (String)enNXTs.nextElement();
                            this.nxtInfos[i++] = new NXTInfo(2, ne, (String)nxtNames.get(ne));
                        }
                    }
                } else {
                    this.debug("No NXTs found in cache file");
                }
            }
            catch (NXTCommException ex) {
                this.log("Failed to load cache file");
            }
            if (this.nxtInfos.length == 0) {
                this.log("Searching for " + searchFor + " using Bluetooth inquiry");
                try {
                    this.nxtInfos = this.nxtComm.search(searchParam, 2);
                }
                catch (NXTCommException ex) {
                    this.log("Search Failed: " + ex.getMessage());
                }
                this.debug("Inquiry found " + this.nxtInfos.length + " NXTs");
                for (int i = 0; i < this.nxtInfos.length; ++i) {
                    this.log("Name " + i + " = " + this.nxtInfos[i].name);
                    this.log("Address " + i + " = " + this.nxtInfos[i].deviceAddress);
                    props.put("NXT_" + this.nxtInfos[i].name, this.nxtInfos[i].deviceAddress);
                }
                this.debug("Saving cached names");
                try {
                    NXTCommFactory.saveNXJCache(props, "Results from Bluetooth inquiry");
                }
                catch (IOException ex) {
                    this.log("Failed to write cache file: " + ex.getMessage());
                }
            }
        }
        if (this.nxtInfos.length == 0) {
            this.log("Failed to find any NXTs");
        }
        return this.nxtInfos;
    }

    public boolean connectTo(String nxt, String addr, int protocols, int mode) {
        boolean opened = false;
        this.nxtInfo = null;
        this.is = null;
        this.os = null;
        this.dataIn = null;
        this.dataOut = null;
        this.search(nxt, addr, protocols);
        for (int i = 0; i < this.nxtInfos.length; ++i) {
            try {
                this.debug("Connecting to " + this.nxtInfos[i].name + " " + this.nxtInfos[i].deviceAddress + " in mode " + mode);
                opened = this.nxtComm.open(this.nxtInfos[i], mode);
                if (opened) {
                    this.nxtInfo = this.nxtInfos[i];
                    this.log("Connected to " + this.nxtInfo.name);
                    break;
                }
                this.log("Failed to open " + this.nxtInfos[i].name + " " + this.nxtInfos[i].deviceAddress);
                continue;
            }
            catch (NXTCommException ex) {
                this.log("Exception in open: " + ex.getMessage());
            }
        }
        if (!opened) {
            this.log("Failed to connect to any NXT");
            return false;
        }
        this.setStreams();
        return true;
    }

    public boolean connectTo(NXTInfo nxtInfo, int mode) {
        this.nxtInfo = nxtInfo;
        if (nxtInfo.protocol == 1) {
            if (this.nxtCommUSB == null) {
                try {
                    this.nxtComm = this.nxtCommUSB = NXTCommFactory.createNXTComm(1);
                }
                catch (NXTCommException e) {
                    this.log("Failed to load USB comms driver: " + e.getMessage());
                    return false;
                }
            }
            this.nxtComm = this.nxtCommUSB;
        }
        if (nxtInfo.protocol == 2) {
            if (this.nxtCommBluetooth == null) {
                try {
                    this.nxtComm = this.nxtCommBluetooth = NXTCommFactory.createNXTComm(2);
                }
                catch (NXTCommException e) {
                    this.log("Failed to load Bluetooth comms driver: " + e.getMessage());
                    return false;
                }
            }
            this.nxtComm = this.nxtCommBluetooth;
        }
        try {
            boolean opened = this.nxtComm.open(nxtInfo, mode);
            if (!opened) {
                this.log("Failed to connect to the specified NXT");
                return false;
            }
            this.setStreams();
            return true;
        }
        catch (NXTCommException e) {
            this.log("Exception connecting to NXT: " + e.getMessage());
            return false;
        }
    }

    public boolean connectTo(String deviceURL, int mode) {
        String nameString;
        boolean isAddress;
        String protocolString = "";
        int colonIndex = deviceURL.indexOf(58);
        if (colonIndex >= 0) {
            protocolString = deviceURL.substring(0, colonIndex);
        }
        String addr = null;
        String name = null;
        int protocols = 3;
        if (protocolString.equals("btspp")) {
            protocols = 2;
        }
        if (protocolString.equals("usb")) {
            protocols = 1;
        }
        if (colonIndex >= 0) {
            colonIndex += 2;
        }
        if (isAddress = (nameString = deviceURL.substring(colonIndex + 1)).startsWith("00")) {
            addr = nameString;
            name = "Unknown";
        } else {
            name = nameString;
            addr = null;
        }
        return this.connectTo(name, addr, protocols, mode);
    }

    public boolean connectTo(String deviceURL) {
        return this.connectTo(deviceURL, 0);
    }

    private void setStreams() {
        this.is = this.nxtComm.getInputStream();
        this.dataIn = new DataInputStream(this.nxtComm.getInputStream());
        this.os = this.nxtComm.getOutputStream();
        this.dataOut = new DataOutputStream(this.os);
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public DataInputStream getDataIn() {
        return this.dataIn;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public DataOutputStream getDataOut() {
        return this.dataOut;
    }

    public NXTInfo getNXTInfo() {
        return this.nxtInfo;
    }

    public NXTInfo[] getNXTInfos() {
        return this.nxtInfos;
    }

    public NXTComm getNXTComm() {
        return this.nxtComm;
    }

    public void close() throws IOException {
        if (this.nxtComm != null) {
            this.nxtComm.close();
        }
    }

    private void debug(String msg) {
        if (this.debugOn) {
            this.log(msg);
        }
    }

    public void setDebug(boolean debug) {
        this.debugOn = debug;
    }
}

