/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Vector;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;
import lejos.pc.comm.NXTCommInputStream;
import lejos.pc.comm.NXTCommOutputStream;
import lejos.pc.comm.NXTConnectionState;
import lejos.pc.comm.NXTInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NXTCommUSB
implements NXTComm {
    private NXTInfo nxtInfo;
    private boolean packetMode = false;
    private boolean EOF = false;
    static final int USB_BUFSZ = 64;
    static final String VENDOR_ATMEL = "0x03EB";
    static final String PRODUCT_SAMBA = "0x6124";
    private byte[] inBuf = new byte[64];
    private byte[] outBuf = new byte[64];

    abstract Vector<NXTInfo> devFind();

    abstract long devOpen(NXTInfo var1);

    abstract void devClose(long var1);

    abstract int devWrite(long var1, byte[] var3, int var4, int var5);

    abstract int devRead(long var1, byte[] var3, int var4, int var5);

    abstract boolean devIsValid(NXTInfo var1);

    String getAddressString(String addr, int loc) {
        int start;
        int end;
        if (addr == null || addr.length() == 0) {
            return null;
        }
        if (loc < 0) {
            start = end = addr.length();
            while (true) {
                if ((start = addr.lastIndexOf("::", end - 2) + 2) < 2) {
                    start = 0;
                }
                if (++loc < 0) {
                    if (start <= 0) {
                        return null;
                    }
                    end = start - 2;
                    continue;
                }
                break;
            }
        } else {
            start = 0;
            end = 0;
            while (true) {
                if ((end = addr.indexOf("::", start)) < 0) {
                    end = addr.length();
                }
                if (start > end) {
                    return null;
                }
                if (--loc <= 0) break;
                if (end >= addr.length()) {
                    return null;
                }
                start = end + 2;
            }
        }
        if (start > end) {
            return null;
        }
        return addr.substring(start, end);
    }

    private String getName(NXTInfo dev) {
        int ret;
        String name = null;
        long nxt = this.devOpen(dev);
        if (nxt == 0L) {
            return name;
        }
        byte[] request = new byte[]{1, -101};
        if (this.devWrite(nxt, request, 0, request.length) > 0 && (ret = this.devRead(nxt, this.inBuf, 0, 33)) >= 33) {
            char[] nameChars = new char[16];
            int len = 0;
            for (int i = 0; i < 15 && this.inBuf[i + 3] != 0; ++i) {
                nameChars[i] = (char)this.inBuf[i + 3];
                ++len;
            }
            name = new String(nameChars, 0, len);
        }
        this.devClose(nxt);
        return name;
    }

    private byte[] readPacket(boolean block) throws IOException {
        int len;
        while ((len = this.devRead(this.nxtInfo.nxtPtr, this.inBuf, 0, this.inBuf.length)) == 0 && block) {
        }
        if (len < 0) {
            throw new IOException("Error in read");
        }
        int offset = 0;
        if (this.packetMode) {
            if ((this.inBuf[0] & 0xFF) != len - 1) {
                throw new IOException("Bad packet format");
            }
            if (this.inBuf[0] == 0) {
                return null;
            }
            offset = 1;
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] ret = new byte[len - offset];
        System.arraycopy(this.inBuf, offset, ret, 0, len - offset);
        return ret;
    }

    private int writePacket(byte[] data, int offset, int len, boolean block) throws IOException {
        int ret;
        byte[] out = null;
        if (this.packetMode) {
            if (len > 63) {
                len = 63;
            }
            this.outBuf[0] = (byte)len;
            System.arraycopy(data, offset, this.outBuf, 1, len);
            out = this.outBuf;
            offset = 0;
            ++len;
        } else {
            out = data;
        }
        while ((ret = this.devWrite(this.nxtInfo.nxtPtr, out, offset, len)) == 0 && block) {
        }
        if (ret < 0) {
            throw new IOException("Error in write");
        }
        return ret;
    }

    private boolean writeEOF() {
        this.outBuf[0] = 0;
        return this.devWrite(this.nxtInfo.nxtPtr, this.outBuf, 0, 1) == 1;
    }

    private void waitEOF() {
        while (this.devRead(this.nxtInfo.nxtPtr, this.inBuf, 0, this.inBuf.length) > 1) {
        }
    }

    Vector<NXTInfo> find(String[] nxtNames) {
        if (nxtNames == null) {
            return new Vector<NXTInfo>();
        }
        Vector<NXTInfo> nxtInfos = new Vector<NXTInfo>();
        for (int idx = 0; idx < nxtNames.length; ++idx) {
            String addr = nxtNames[idx];
            NXTInfo info = new NXTInfo();
            info.name = null;
            info.btResourceString = addr;
            info.protocol = 1;
            if (this.getAddressString(addr, 2).equals(VENDOR_ATMEL) && this.getAddressString(addr, 3).equals(PRODUCT_SAMBA)) {
                info.name = "%%NXT-SAMBA%%";
            }
            info.deviceAddress = this.getAddressString(addr, -2);
            if (info.deviceAddress != null && !info.deviceAddress.equals("000000000000")) {
                nxtInfos.addElement(info);
                continue;
            }
            System.out.println("Ignoring device " + addr);
        }
        return nxtInfos;
    }

    @Override
    public NXTInfo[] search(String name, int protocol) {
        int i;
        Vector<NXTInfo> nxtInfos = this.devFind();
        if (nxtInfos.size() == 0) {
            return new NXTInfo[0];
        }
        Iterator<NXTInfo> devs = nxtInfos.iterator();
        int nameCnt = 0;
        while (devs.hasNext()) {
            NXTInfo nxt = devs.next();
            if (nxt.deviceAddress == null) {
                nxt.deviceAddress = "000000000000";
            }
            if (nxt.name == null) {
                nxt.name = this.getName(nxt);
            }
            if (!(name == null || nxt.name != null && name.equals(nxt.name))) {
                devs.remove();
                continue;
            }
            if (nxt.name == null) continue;
            ++nameCnt;
        }
        NXTInfo[] nxts = new NXTInfo[nxtInfos.size()];
        int named = 0;
        int unnamed = nameCnt;
        for (i = 0; i < nxts.length; ++i) {
            NXTInfo nxt = nxtInfos.elementAt(i);
            if (nxt.name == null) {
                nxt.name = "Unknown";
                nxts[unnamed++] = nxt;
                continue;
            }
            nxts[named++] = nxt;
        }
        for (i = 0; i < nxts.length; ++i) {
            System.out.println("Found NXT: " + nxts[i].name + " " + nxts[i].deviceAddress);
        }
        return nxts;
    }

    @Override
    public boolean open(NXTInfo nxtInfo, int mode) {
        nxtInfo.connectionState = NXTConnectionState.DISCONNECTED;
        if (!this.devIsValid(nxtInfo)) {
            String addr = nxtInfo.deviceAddress;
            if (addr == null || addr.length() == 0) {
                return false;
            }
            Vector<NXTInfo> nxtInfos = this.devFind();
            for (NXTInfo nxt : nxtInfos) {
                if (!addr.equalsIgnoreCase(nxt.deviceAddress)) continue;
                nxtInfo = nxt;
                break;
            }
        }
        if (nxtInfo == null) {
            return false;
        }
        this.nxtInfo = nxtInfo;
        this.nxtInfo.nxtPtr = this.devOpen(nxtInfo);
        if (this.nxtInfo.nxtPtr == 0L) {
            return false;
        }
        NXTConnectionState nXTConnectionState = nxtInfo.connectionState = mode == 1 ? NXTConnectionState.LCP_CONNECTED : NXTConnectionState.PACKET_STREAM_CONNECTED;
        if (mode == 2 || mode == 1) {
            return true;
        }
        byte[] request = new byte[]{1, -1};
        byte[] ret = null;
        try {
            ret = this.sendRequest(request, 64);
        }
        catch (IOException e) {
            ret = null;
        }
        if (ret != null && ret.length >= 3 && ret[0] == 2 && ret[1] == -2 && ret[2] == -17) {
            this.packetMode = true;
        }
        this.EOF = false;
        return true;
    }

    @Override
    public boolean open(NXTInfo nxt) throws NXTCommException {
        return this.open(nxt, 0);
    }

    @Override
    public void close() {
        if (this.nxtInfo == null || this.nxtInfo.nxtPtr == 0L) {
            return;
        }
        if (this.packetMode) {
            this.writeEOF();
            if (!this.EOF) {
                this.waitEOF();
            }
        }
        this.devClose(this.nxtInfo.nxtPtr);
        this.nxtInfo.nxtPtr = 0L;
    }

    @Override
    public byte[] sendRequest(byte[] data, int replyLen) throws IOException {
        int written = this.devWrite(this.nxtInfo.nxtPtr, data, 0, data.length);
        if (written <= 0) {
            throw new IOException("Failed to send data");
        }
        if (replyLen == 0) {
            return new byte[0];
        }
        byte[] ret = new byte[replyLen];
        int len = this.devRead(this.nxtInfo.nxtPtr, ret, 0, replyLen);
        if (len <= 0) {
            throw new IOException("Failed to read reply");
        }
        return ret;
    }

    byte[] read(boolean timeout) throws IOException {
        if (this.EOF) {
            return null;
        }
        byte[] ret = this.readPacket(timeout);
        if (this.packetMode && ret == null) {
            this.EOF = true;
        }
        return ret;
    }

    @Override
    public byte[] read() throws IOException {
        return this.read(true);
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    int write(byte[] data, boolean block) throws IOException {
        int written;
        int len;
        int total = data.length;
        for (written = 0; written < total; written += len) {
            len = this.writePacket(data, written, total - written, block);
            if (len > 0) continue;
            return written;
        }
        return written;
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, true);
    }

    @Override
    public OutputStream getOutputStream() {
        return new NXTCommOutputStream(this);
    }

    @Override
    public InputStream getInputStream() {
        return new NXTCommInputStream(this);
    }
}

