/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.IOException;
import java.io.InputStream;
import lejos.pc.comm.NXTComm;

public class NXTCommInputStream
extends InputStream {
    private NXTComm nxtComm;
    private byte[] buf;
    private int bufIdx;
    private int bufSize;
    boolean endOfFile;

    public NXTCommInputStream(NXTComm nxtComm) {
        this.nxtComm = nxtComm;
        this.endOfFile = false;
        this.bufIdx = 0;
        this.bufSize = 0;
    }

    public int read() throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        if (this.bufIdx >= this.bufSize) {
            this.bufSize = 0;
        }
        if (this.bufSize == 0) {
            this.bufIdx = 0;
            this.buf = this.nxtComm.read();
            if (this.buf == null || this.buf.length == 0) {
                this.endOfFile = true;
                return -1;
            }
            this.bufSize = this.buf.length;
        }
        return this.buf[this.bufIdx++] & 0xFF;
    }

    public int available() throws IOException {
        return this.bufSize - this.bufIdx;
    }

    public void close() throws IOException {
        this.endOfFile = true;
    }
}

