/*
 * Decompiled with CFR 0.152.
 */
package lejos.pc.comm;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import lejos.pc.comm.NXTComm;
import lejos.pc.comm.NXTCommException;

public class NXTCommFactory {
    public static final int USB = 1;
    public static final int BLUETOOTH = 2;
    public static final int ALL_PROTOCOLS = 3;
    private static String os = System.getProperty("os.name");
    private static final String SEP = System.getProperty("file.separator");
    private static final String USER_HOME = System.getProperty("user.home");
    private static String propFile;
    private static String cacheFile;

    public static NXTComm createNXTComm(int protocol) throws NXTCommException {
        boolean fantom = false;
        Properties props = NXTCommFactory.getNXJProperties();
        if (os.length() >= 7 && os.substring(0, 7).equals("Windows") || os.toLowerCase().startsWith("mac os x")) {
            fantom = true;
        }
        if ((protocol & 1) != 0) {
            String nxtCommName = props.getProperty("NXTCommUSB", fantom ? "lejos.pc.comm.NXTCommFantom" : "lejos.pc.comm.NXTCommLibnxt");
            try {
                Class<?> c = Class.forName(nxtCommName);
                return (NXTComm)c.newInstance();
            }
            catch (Throwable t) {
                throw new NXTCommException("Cannot load USB driver");
            }
        }
        String defaultDriver = "lejos.pc.comm.NXTCommBluecove";
        if ((protocol & 2) != 0) {
            String nxtCommName = props.getProperty("NXTCommBluetooth", defaultDriver);
            try {
                Class<?> c = Class.forName(nxtCommName);
                return (NXTComm)c.newInstance();
            }
            catch (Throwable t) {
                throw new NXTCommException("Cannot load Bluetooth driver");
            }
        }
        return null;
    }

    private static void setPropsFile() {
        String home = System.getProperty("nxj.home");
        if (home == null) {
            home = System.getenv("NXJ_HOME");
        }
        if (home != null) {
            propFile = home + SEP + "bin" + SEP + "nxj.properties";
        }
    }

    public static Properties getNXJProperties() throws NXTCommException {
        Properties props = new Properties();
        NXTCommFactory.setPropsFile();
        if (propFile != null) {
            try {
                props.load(new FileInputStream(propFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                throw new NXTCommException("Cannot read nxj.properties file");
            }
        }
        return props;
    }

    public static Properties getNXJCache() throws NXTCommException {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(cacheFile));
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            throw new NXTCommException("Cannot read nxj.cache file");
        }
        return props;
    }

    public static void saveNXJProperties(Properties props, String comment) throws IOException {
        NXTCommFactory.setPropsFile();
        FileOutputStream fos = new FileOutputStream(propFile);
        props.store(fos, comment);
    }

    public static void saveNXJCache(Properties props, String comment) throws IOException {
        FileOutputStream fos = new FileOutputStream(cacheFile);
        props.store(fos, comment);
    }

    static {
        cacheFile = USER_HOME + SEP + "nxj.cache";
    }
}

