/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import lejos.nxt.I2CPort;
import lejos.nxt.I2CSensor;

public class NXTLineLeader
extends I2CSensor {
    byte[] buf = new byte[8];
    private static final byte COMMAND = 65;
    private static final byte LL_WRITE_KP = 70;
    private static final byte LL_WRITE_KI = 71;
    private static final byte LL_WRITE_KD = 72;
    private static final byte LL_READ_STEERING = 66;
    private static final byte LL_READ_AVERAGE = 67;
    private static final byte LL_READ_RESULT = 68;
    private final byte[] whiteReadingLimits = new byte[]{81, 82, 83, 84, 85, 86, 87, 88};

    public NXTLineLeader(I2CPort port) {
        super(port);
        port.setType(11);
    }

    public void sendCommand(char cmd) {
        this.sendData(65, (byte)cmd);
    }

    public void sleep() {
        this.sendCommand('D');
    }

    public void wakeUp() {
        this.sendCommand('P');
    }

    public int getSteering() {
        int ret = this.getData(66, this.buf, 2);
        int steering = 0;
        steering = ret == 0 ? this.buf[0] & 0xFF : -1;
        return steering;
    }

    public int getAverage() {
        int ret = this.getData(67, this.buf, 2);
        int average = 0;
        average = ret == 0 ? this.buf[0] & 0xFF : -1;
        return average;
    }

    public int getResult() {
        int ret = this.getData(68, this.buf, 2);
        int result = 0;
        result = ret == 0 ? this.buf[0] & 0xFF : -1;
        return result;
    }

    public int getKP() {
        int ret = this.getData(70, this.buf, 2);
        int KP = 0;
        KP = ret == 0 ? this.buf[0] & 0xFF : -1;
        return KP;
    }

    public void setKP(int KP) {
        this.sendData(70, (byte)KP);
    }

    public int getKI() {
        int ret = this.getData(71, this.buf, 2);
        int KI = 0;
        KI = ret == 0 ? this.buf[0] & 0xFF : -1;
        return KI;
    }

    public void setKI(int KI) {
        this.sendData(70, (byte)KI);
    }

    public int getKD() {
        int ret = this.getData(72, this.buf, 2);
        int KD = 0;
        KD = ret == 0 ? this.buf[0] & 0xFF : -1;
        return KD;
    }

    public void setKD(int KD) {
        this.sendData(72, (byte)KD);
    }

    public int getSensorStatus(int index) {
        int ret = this.getData(this.whiteReadingLimits[index], this.buf, 2);
        int status = 0;
        status = ret == 0 ? this.buf[0] & 0xFF : -1;
        return status;
    }
}

