/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import lejos.nxt.I2CSensor;
import lejos.nxt.SensorPort;

public class MServo
extends I2CSensor {
    private int servoPosition = 0;
    private final byte SERVO1_POSITION = (byte)90;
    private final byte SERVO1_SPEED = (byte)82;
    private int angle = 0;
    private int pulse = 0;
    private int minAngle = 0;
    private int maxAngle = 180;
    private int minPulse = 650;
    private int maxPulse = 2350;

    public MServo(SensorPort port, int location) {
        super(port);
        this.servoPosition = location;
    }

    public MServo(SensorPort port, int location, String servoName) {
        super(port);
        this.servoPosition = location;
    }

    public MServo(SensorPort port, int location, String servoName, int min_angle, int max_angle) {
        this(port, location, servoName);
        this.minAngle = min_angle;
        this.maxAngle = max_angle;
    }

    private float getLinearInterpolation(float x, float x1, float x2, float y1, float y2) {
        float y = (y2 - y1) / (x2 - x1) * (x - x1) + y1;
        return y;
    }

    public void setPulse(int pulse) {
        this.pulse = pulse;
        int internalPulse = Math.round(pulse / 10);
        this.setAddress(88);
        this.sendData(90 + this.servoPosition - 1, (byte)internalPulse);
    }

    public int getPulse() {
        return this.pulse;
    }

    public void setAngle(int angle) {
        this.angle = angle;
        this.pulse = Math.round(this.getLinearInterpolation(angle, this.minAngle, this.maxAngle, this.minPulse, this.maxPulse));
        this.setPulse(this.pulse);
    }

    public int getAngle() {
        return this.angle;
    }

    public void setSpeed(int speed) {
        this.setAddress(88);
        this.sendData(82 + this.servoPosition - 1, (byte)speed);
    }
}

