/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt.addon;

import lejos.nxt.I2CSensor;
import lejos.nxt.SensorPort;

public class LMotor
extends I2CSensor {
    private String name = "";
    protected int LSC_position;
    private SensorPort portConnected;
    protected byte SPI_PORT;
    public static final int[] arrMotorUnload = new int[]{1, 2, 4, 8, 32, 64, 128, 256, 512};
    public static final int[] arrMotorLoad = new int[]{1022, 1021, 1019, 1015, 1007, 991, 959, 895, 767, 511};

    public LMotor(SensorPort port, int location, String name, byte SPI_PORT) {
        super(port);
        this.name = name;
        this.LSC_position = location;
        this.SPI_PORT = SPI_PORT;
        this.setAddress(40);
    }

    private int readMotion() {
        byte[] bufReadResponse = new byte[8];
        int motion = -1;
        int I2C_Response = this.sendData(this.SPI_PORT, (byte)104);
        I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        I2C_Response = this.getData(this.SPI_PORT, bufReadResponse, 1);
        byte h_byte = bufReadResponse[0];
        I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        I2C_Response = this.getData(this.SPI_PORT, bufReadResponse, 1);
        byte l_byte = bufReadResponse[0];
        motion = l_byte == 255 ? ((h_byte & 7) << 8) + 255 : (h_byte & 7) << 8 | l_byte & 0xFF;
        return motion;
    }

    public boolean isMoving() {
        boolean flag = false;
        if (this.readMotion() != 0) {
            flag = true;
        }
        return flag;
    }

    public void setDelay(int delay) {
        int motor = this.LSC_position;
        byte h_byte = -16;
        byte l_byte = (byte)((motor << 4) + delay);
        int I2C_Response = this.sendData(this.SPI_PORT, h_byte);
        I2C_Response = this.sendData(this.SPI_PORT, l_byte);
    }

    public void unload() {
        int channel = 0;
        channel = arrMotorUnload[this.LSC_position];
        byte h_byte = -32;
        byte l_byte = (byte)channel;
        int I2C_Response = this.sendData(this.SPI_PORT, h_byte);
        I2C_Response = this.sendData(this.SPI_PORT, l_byte);
    }

    public void load() {
        int channel = 0;
        channel = arrMotorLoad[this.LSC_position];
        byte h_byte = -32;
        byte l_byte = (byte)channel;
        int I2C_Response = this.sendData(this.SPI_PORT, h_byte);
        I2C_Response = this.sendData(this.SPI_PORT, l_byte);
    }

    public String getName() {
        return this.name;
    }

    protected void setPulse(int pulse) {
        int servo = this.LSC_position;
        byte h_byte = (byte)(0x80 | (servo << 3 | pulse >> 8));
        byte l_byte = (byte)pulse;
        int I2C_Response = this.sendData(this.SPI_PORT, h_byte);
        I2C_Response = this.sendData(this.SPI_PORT, l_byte);
    }

    protected int getPulse() {
        byte[] bufReadResponse = new byte[8];
        int servo = this.LSC_position;
        byte h_byte = (byte)(servo << 3);
        int I2C_Response = this.sendData(this.SPI_PORT, h_byte);
        I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        I2C_Response = this.getData(this.SPI_PORT, bufReadResponse, 1);
        h_byte = bufReadResponse[0];
        I2C_Response = this.sendData(this.SPI_PORT, (byte)0);
        I2C_Response = this.getData(this.SPI_PORT, bufReadResponse, 1);
        byte l_byte = bufReadResponse[0];
        return ((h_byte & 7) << 8) + (l_byte & 0xFF);
    }
}

