/*
 * Decompiled with CFR 0.152.
 */
package lejos.nxt;

import java.io.IOException;
import lejos.nxt.I2CPort;
import lejos.nxt.LegacySensorPort;
import lejos.nxt.remote.InputValues;
import lejos.nxt.remote.NXTCommand;
import lejos.nxt.remote.NXTProtocol;
import lejos.pc.comm.NXTCommandConnector;

public class SensorPort
implements NXTProtocol,
LegacySensorPort,
I2CPort {
    private static final NXTCommand nxtCommand = NXTCommandConnector.getSingletonOpen();
    private int id;
    public static SensorPort S1 = new SensorPort(0);
    public static SensorPort S2 = new SensorPort(1);
    public static SensorPort S3 = new SensorPort(2);
    public static SensorPort S4 = new SensorPort(3);

    private SensorPort(int port) {
        this.id = port;
    }

    public int getId() {
        return this.id;
    }

    public void setTypeAndMode(int type, int mode) {
        try {
            nxtCommand.setInputMode(this.id, type, mode);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public void setType(int type) {
        int mode = this.getMode();
        try {
            nxtCommand.setInputMode(this.id, type, mode);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public void setMode(int mode) {
        int type = this.getType();
        try {
            nxtCommand.setInputMode(this.id, type, mode);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    public int getType() {
        InputValues vals;
        try {
            vals = nxtCommand.getInputValues(this.id);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return 0;
        }
        return vals.sensorType;
    }

    public int getMode() {
        InputValues vals;
        try {
            vals = nxtCommand.getInputValues(this.id);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return 0;
        }
        return vals.sensorMode;
    }

    public boolean readBooleanValue() {
        InputValues vals;
        try {
            vals = nxtCommand.getInputValues(this.id);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return false;
        }
        return vals.rawADValue < 600;
    }

    public int readRawValue() {
        InputValues vals;
        try {
            vals = nxtCommand.getInputValues(this.id);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return 1023;
        }
        return vals.rawADValue;
    }

    public int readNormalizedValue() {
        InputValues vals;
        try {
            vals = nxtCommand.getInputValues(this.id);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return 0;
        }
        return vals.normalizedADValue;
    }

    public int readValue() {
        InputValues vals;
        try {
            vals = nxtCommand.getInputValues(this.id);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            return 0;
        }
        return vals.scaledValue;
    }

    public void activate() {
        this.setType(3);
    }

    public void passivate() {
        this.setType(0);
    }

    public int readValues(int[] values) {
        return -1;
    }

    public int readRawValues(int[] values) {
        return -1;
    }

    public void enableColorSensor() {
    }
}

