package fr.upem.jacosa.zoo;

import java.util.Random;

public class Zoo
{
	public static void main(String[] args)
	{
		Feline felix = new Cat("Felix");
		Tiger tigrou = new Tiger("Tigrou");
		Dog momo = new Dog("Momo");
		
		System.out.println(felix.speak(momo));
		System.out.println(momo.speak(felix));
		System.out.println("Tigrou speaks to Felix as a feline: " + tigrou.speak(felix));
		System.out.println("Tigrou speaks to Felix as a cat: " + tigrou.speak((Cat)felix));
		System.out.println("Tigrou as a feline speaks to Felix as a cat: " 
				+ ((Feline)tigrou).speak((Cat)felix) );
		// System.out.println(tigrou.speak(momo));
		
		// using an array to speak with several animals
		Animal[] a = new Animal[2];
		a[0] = felix;
		a[1] = tigrou;
		System.out.println(felix.multiSpeak(a));
		
		Random r = new Random();
		int i = r.nextInt(2);
		System.out.println(i);
		
		Animal z = null;
		if (i == 0)
			z = new Cat("Felix");
		else
			z = new Tiger("Tigrou");
		System.out.println("Is a Feline? " + (z instanceof Feline));
		System.out.println("Has the animal whiskers? " + (z instanceof HasWhiskers));
		System.out.println("Is the animal whiskers? " + z.getClass().equals(HasWhiskers.class));
		System.out.println("Class of the animal: " + z.getClass());
		System.out.println("Is the class Cat? " + z.getClass().equals(Cat.class));
		System.out.println("Is the class Tiger? " + z.getClass().equals(Tiger.class));
		if (z instanceof Cat)
		{
			Cat c = (Cat)z;
			System.out.println(c);
		}
		
		Animal strangeAnimal = new Animal("Jules")
		{
			@Override
			public String speak()
			{
				return "ggrtghrthrtez";
			}
		};
		
		Dog anonymousDog = new Dog("anonymous")
		{
			@Override
			public String speak()
			{
				return "@@@@@@@@@@";
			}
		};
		
		System.out.println("Jules speaks: " + strangeAnimal.speak());
		System.out.println("Anonymous speaks: " + anonymousDog.speak());
		System.out.println("Class of anonymousDog: " + anonymousDog.getClass());
	}

}
