package fr.upem.jacosa.zoo;

/**
 * An animal from the zoo
 * @author MC
 *
 */
public abstract class Animal extends Object 
{
	private final String name;
	
	/**
	 * Initialize a new animal with a name
	 * @param name the name of the animal
	 */
	public Animal(String name)
	{
		this.name = name;
	}
	
	public String getName()
	{
		return name;
	}
	
	public abstract String speak();
	
	public String speakTwice()
	{
		return speak() + " " + speak();
	}
	
	@Override
	public String toString()
	{
		return getName();
	}
}
