import java.util.*;
import java.io.*;

public class Piper
{
	public static final int BUFF_LEN = 1024;
	
	public static Runnable getTransferer(final InputStream in, final OutputStream out)
	{
		return new Runnable(){
			@Override
			public void run()
			{
				try {
					byte[] buff = new byte[BUFF_LEN];
					for (int i = in.read(buff); i >= 0; i = in.read(buff))
					{
						out.write(buff, 0, i);
					}
				} catch (IOException e)
				{
					e.printStackTrace();
				} finally
				{
					try {
						in.close();
						out.close();
					} catch (IOException e)
					{
						e.printStackTrace();
					}
				}
			}
		};
	}

	public static int execute(List<List<String>> commands) throws IOException, InterruptedException
	{
		final List<Process> processes = new ArrayList<Process>();
		for (List<String> command: commands)
			processes.add(new ProcessBuilder(command).start());
		for (int i = 0; i < processes.size(); i++)
		{
			final InputStream currentOut = processes.get(i).getInputStream();
			final OutputStream followingIn = (i+1 < processes.size())?
				processes.get(i+1).getOutputStream():System.out;
			new Thread(getTransferer(currentOut, followingIn)).start();
		}
		return processes.get(processes.size() - 1).waitFor();
	}
	
	public static void main(String[] args) throws Exception
	{
		List<List<String>> l = new ArrayList<List<String>>();
		List<String> command = new ArrayList<String>();
		for (String arg: args)
		{
			if (arg.equals("|"))
			{
				l.add(command);
				command = new ArrayList<String>();
			} else
				command.add(arg);
		}
		l.add(command);
		System.exit(execute(l));
	}
}