package fr.upem.jacosa.threads;

public class ParkingPlace implements AutoCloseable
{
	private boolean handicapped;
	private ParkingLot lot;
	
	public ParkingPlace(ParkingLot lot, boolean handicapped) {
		this.handicapped = handicapped;
		this.lot = lot;
	}
	
	public void close() {
		lot.lock.lock();
		try {
			if (handicapped) lot.remainingHandicapped++;
			else lot.remainingClassical++;
			lot.anyFree.signal();
			if (! handicapped) lot.classicalFree.signal();
		} finally
		{
			lot.lock.unlock();
		}
	}
}
