package fr.upem.jacosa.threads;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ParkingLot
{
	int remainingClassical;
	int remainingHandicapped;
	
	Lock lock;
	Condition classicalFree;
	Condition anyFree;
	
	public ParkingLot(int c, int h)
	{
		this.lock = new ReentrantLock();
		this.classicalFree = lock.newCondition();
		this.anyFree = lock.newCondition();
		this.remainingClassical = c;
		this.remainingHandicapped = h;
	}
	
	public ParkingPlace takePlace() throws InterruptedException
	{
		lock.lock();
		try {
			while (remainingClassical == 0)
				classicalFree.await();
			remainingClassical--;
			return new ParkingPlace(this, false);
		} finally
		{
			lock.unlock();
		}
	}
	
	public ParkingPlace takeHandicapedPlace() throws InterruptedException
	{
		lock.lock();
		try {
			while (remainingClassical == 0 && remainingHandicapped == 0)
				anyFree.await();
			boolean handicapped = remainingClassical == 0;
			if (handicapped) remainingHandicapped--; else remainingClassical--;
			return new ParkingPlace(this, handicapped);
		} finally
		{
			lock.unlock();
		}
	}
}
