package fr.upem.jacosa.threads;

public class BoundedWait
{
	public static class Counter
	{
		private long value = 0;
		
		public synchronized void increment()
		{
			value++;
			this.notifyAll(); // to wakeup all the possible waiting threads
		}
		
		public synchronized long get()
		{
			return value;
		}
		
		public synchronized long waitForValue(long expectedValue, int timeoutInMillis) throws InterruptedException
		{
			long startTime = System.nanoTime();
			long remainingTimeInMillis = ((startTime + timeoutInMillis * 1_000_000L) - System.nanoTime()) / 1_000_000L;
			while (value < expectedValue && remainingTimeInMillis > 0)
			{
				this.wait(remainingTimeInMillis);
				remainingTimeInMillis = ((startTime + timeoutInMillis * 1_000_000L) - System.nanoTime()) / 1_000_000L;
			}
			return value;
		}
	}
	
	public static void main(String[] args) throws InterruptedException
	{
		long counterBound = Long.parseLong(args[0]);
		int timeBound = 5000; // in milliseconds
		Counter c = new Counter();
		Thread t = new Thread(() -> {
			while (! Thread.interrupted()) 
				c.increment(); 
			System.out.println("End of incrementing thread");
		});
		t.start();
		System.out.println(c.waitForValue(counterBound, timeBound)); // wait until counterBound is reached or time is hit
		t.interrupt(); // stop the incrementing thread
	}
}
