package fr.upem.jacosa.serialization;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import java.util.Arrays;
import java.util.HashMap;

/**
 * Very simple application to print the encountered tags in a XML document
 * using the cursor approach of the StAX API.
 */
public class SimpleStAXCursorApp {
    public static void main(String[] args) throws XMLStreamException {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        XMLStreamReader reader = xmlif.createXMLStreamReader(System.in);
        try {
            while (reader.hasNext()) {
                int eventType = reader.next();
                switch (eventType) {
                    case XMLStreamConstants.START_DOCUMENT -> System.out.println("Start of the document");
                    case XMLStreamConstants.END_DOCUMENT -> System.out.println("End of the document");
                    case XMLStreamConstants.COMMENT -> System.out.println("Encountered comment: " + reader.getText());
                    case XMLStreamConstants.START_ELEMENT -> {
                        var attributes = new HashMap<String, String>();
                        for (int i = 0; i < reader.getAttributeCount(); i++)
                            attributes.put(reader.getAttributeName(i).getLocalPart(), reader.getAttributeValue(i));
                        System.out.println("Start element " + reader.getName() + " with attributes " + attributes);
                    }
                    case XMLStreamConstants.END_ELEMENT -> System.out.println("End element " + reader.getName());
                    case XMLStreamConstants.CHARACTERS -> System.out.println("Encountered characters " + reader.getText());
                }
            }
        } finally {
            reader.close();
        }
    }
}
