package fr.upem.jacosa.serialization;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import java.util.TreeSet;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;

public class SAXReferencer
{
	public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException {
		Reader r = new InputStreamReader(System.in);
		// Where to store each tag name
		final Set<String> tagSet = new TreeSet<String>();
		XMLReader saxReader = SAXParserFactory.newDefaultInstance().newSAXParser().getXMLReader();
		saxReader.setContentHandler(new DefaultHandler() {
			public void startElement(
				String uri, String localName, String qName, Attributes attributes)
			{
				tagSet.add(qName); // We use the qualified name
			}
		});
		saxReader.parse(new InputSource(r));
		System.out.println(tagSet);
	}
}