package fr.upem.jacosa.serialization;

import org.jsoup.Jsoup;

import java.io.IOException;
import java.util.regex.Pattern;

public class JSoupDemo {
    /**
     * With this demonstration of JSoup, we webscrap the trafic information in Paris area
     * using the website sytadin.fr
     * This code may be obsolete if the Sytadin website changes.
     */
    public static void main(String[] args) throws IOException {
        var jamRegex = Pattern.compile("([0-9]+) km");
        var doc = Jsoup.connect("http://www.sytadin.fr/").get();
        System.out.println("Title: " + doc.title());
        var jam = doc.getElementById("cumul_bouchon");
        int jamLength = -1;
        for (var child: jam.children()) {
            if (child.tagName().equals("img")) {
                String alt = child.attr("alt");
                var matcher = jamRegex.matcher(alt);
                if (matcher.matches())
                    jamLength = Integer.parseInt(matcher.group(1));
            }
            if (jamLength >= 0) break;
        }
        if (jamLength < 0)
            System.out.println("Cannot find jam length");
        else
            System.out.println(String.format("Jam length: %d", jamLength));
    }
}
