package fr.upem.jacosa.serialization;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;

import org.json.JSONObject;

public class JSONDirectoryTree
{
	/** Recursively build the tree */
	public static Object getTree(File root)
	{
		if (root.isDirectory())
		{
			Map<String, Object> tree = new TreeMap<String, Object>();
			for (File f: root.listFiles())
				tree.put(f.getName(), getTree(f));
			return tree;
		} else
			return root.getName();
	}
	
	public static void main(String[] args)
	{
		File root = new File(args[0]);
		Object tree = getTree(root);
		if (tree instanceof String)
			System.err.println(root + " is a simple file");
		else // root is a directory
			System.out.print(new JSONObject(tree).toString());
	}
}
