package fr.upem.jacosa.serialization;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

/** Extract all the bookks from a given author using a cursor with StAX */
public class BookPuller2
{
	public static String readText(XMLStreamReader reader) throws XMLStreamException {
		int type = reader.next();
		assert(type == XMLStreamConstants.CHARACTERS);
		return reader.getText().trim();
	}
	
	public static void main(String[] args) throws IOException, XMLStreamException {
		String expectedAuthor = args[0];
		XMLInputFactory xmlif = XMLInputFactory.newInstance();
		XMLStreamReader reader = xmlif.createXMLStreamReader(BookPuller2.class.getResourceAsStream("/books/books.xml"));
		try {
			// Iterate over the events
			String currentTitle = null;
			String currentAuthor = null;
			int eventType = reader.next();
			while (eventType != XMLStreamConstants.END_DOCUMENT && (currentAuthor == null || expectedAuthor.compareTo(currentAuthor) <= 0))
			{
				if (eventType == XMLStreamConstants.START_ELEMENT)
				{
					if (reader.getName().getLocalPart().equals("book"))
						{ currentTitle = currentAuthor = null; }
					if (reader.getName().getLocalPart().equals("title"))
						currentTitle = readText(reader);
					else if (reader.getName().getLocalPart().equals("author"))
						currentAuthor = readText(reader);
				} else if (eventType == XMLStreamConstants.END_ELEMENT && reader.getName().getLocalPart().equals("book"))
				{
					if (expectedAuthor.equals(currentAuthor))
						System.out.println(currentTitle);
				}
				eventType = reader.next();
			}
		} finally {
			reader.close();
		}
	}
}
