package fr.upem.jacosa.serialization;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class BookPuller
{
	public static String readText(XmlPullParser xpp) throws XmlPullParserException, IOException
	{
		xpp.next();
		assert(xpp.getEventType() == XmlPullParser.TEXT);
		return xpp.getText();
	}
	
	public static void main(String[] args) throws IOException, XmlPullParserException
	{
		String expectedAuthor = args[0];
		try (Reader r = new InputStreamReader(System.in))
		{
			// Creating the XML parser
			XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
			factory.setNamespaceAware(true);
			XmlPullParser xpp = factory.newPullParser();
			xpp.setInput(r);
			// Iterate over the events
			String currentTitle = null;
			String currentAuthor = null;
			int eventType = xpp.getEventType();
			while (eventType != xpp.END_DOCUMENT && (currentAuthor == null || expectedAuthor.compareTo(currentAuthor) <= 0))
			{
				if (eventType == xpp.START_TAG)
				{
					if (xpp.getName().equals("book"))
						{ currentTitle = currentAuthor = null; }
					if (xpp.getName().equals("title"))
						currentTitle = readText(xpp);
					else if (xpp.getName().equals("author"))
						currentAuthor = readText(xpp);
				} else if (xpp.getName().equals("book") && eventType == xpp.END_TAG)
				{
					if (expectedAuthor.equals(currentAuthor))
						System.out.println(currentTitle);
				}
				eventType = xpp.next();
			}
		}
	}
}
