package fr.upem.jacosa.serialization;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Book implements Externalizable
{
	private String title;
	private int price;
	
	public Book() { } // A no-arg constructor is required for Externalizable
	public Book(String title, int price) { /* ... */ }
	
	public void writeExternal(ObjectOutput out) throws IOException
	{
		out.writeShort(price); // we assume that the price does not reach 2^15 euros
		// we compress the title by storing first its length
		// and each sequence of identical characters prefixed by their repeat number
		out.writeShort(title.length());
		char currentChar = '\0'; int number = 0;
		for (int i = 0; i <= title.length(); i++)
		{
			if (i < title.length() && title.charAt(i) == currentChar) number++;
			else { 
				if (number > 0) { out.writeChar(currentChar); out.writeByte(number); }
				if (i < title.length()) { currentChar = title.charAt(i); number = 1; }
			}
		}
	}
	
	public void readExternal(ObjectInput in) throws IOException
	{
		price = in.readShort();
		int titleLength = in.readShort();
		StringBuilder sb = new StringBuilder(); int i = 0;
		while (sb.length() < titleLength)
		{
			char c = in.readChar();
			byte repeats = in.readByte();
			for (byte j = 0; j < repeats; j++) sb.append(c);
		}
		title = sb.toString();
	}
}
