package fr.upem.jacosa.safety;

import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

import static org.junit.platform.engine.discovery.ClassNameFilter.includeClassNamePatterns;
import static org.junit.platform.engine.discovery.DiscoverySelectors.selectClass;
import static org.junit.platform.engine.discovery.DiscoverySelectors.selectPackage;

// Copied from the JUnit 5 documentation: https://junit.org/junit5/docs/current/user-guide/#launcher-api-execution
public class TestRunner {
  public static void main(String[] args) {
    LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request()
            .selectors(
                    selectPackage("com.example.mytests"),
                    selectClass(DuplicateRemoverTest.class)
            )
            .filters(
                    includeClassNamePatterns(".*Tests")
            )
            .build();

    Launcher launcher = LauncherFactory.create();
    launcher.execute(request);
  }
} 