package fr.upem.jacosa.safety;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;

import java.util.stream.IntStream;

/** Introduce some parameterized tets using JUnit */
public class SomeParameterizedTests {

    /** Is the indexOf method of string working correctly?
     *  We use a CSV source to test it with some examples
     */
    @DisplayName("Search a needle into a haystack")
    @ParameterizedTest
    @CsvSource({"bonjour,jour,3", "au revoir,rev,3", "foobar,foo,0"})
    void testStringIndexOf(String s, String needle, String expectedIndex) {
        Assertions.assertEquals(expectedIndex, s.indexOf(needle));
    }

    /** Test if the method Math.sqrt works flawlessly with some integers */
    @DisplayName("Test the Math.sqrt method")
    @MethodSource("intGenerator")
    void testSqrt(int i) {
        Assertions.assertEquals(i, Math.sqrt(i*i));
    }

    /** Return the integers from 0 to 1000 */
    public static IntStream intGenerator() {
        return IntStream.iterate(0, x -> x + 1).limit(1000);
    }
}
