package fr.upem.jacosa.safety;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;


import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DuplicateRemoverTest
{
	public static final int LIST_SIZE = 128;
	public static final int MAX_NUMBER = 10;
	
	private List<Integer> list = null;
	private static Random random = null;
	
	@BeforeAll
	public static void initClass()
	{
		random = new Random();
	}
	
	@BeforeEach
	public void initList()
	{
		list = new ArrayList<Integer>();
		for (int i = 0; i < LIST_SIZE; i++)
			list.add(random.nextInt(MAX_NUMBER+1));
		Collections.sort(list);
	}
	
	@Test
	public void testDuplicateRemover()
	{
		Assertions.assertTrue(DuplicateRemover.isSorted(list), "Initial list not sorted");
		int initialSize = list.size();
		int duplicateNumber = DuplicateRemover.getDuplicateNumber(list);
		DuplicateRemover.removeDuplicates(list);
		Assertions.assertTrue( initialSize == list.size() + duplicateNumber, "Incoherent number of removed duplicates");
		Assertions.assertTrue(DuplicateRemover.isSorted(list), "Not sorted list");
	}
	
	@Test
	public void testDuplicateRemover2()
	{
		Set<Integer> set = new HashSet<Integer>(list);
		DuplicateRemover.removeDuplicates(list);
		Set<Integer> set2 = new HashSet<Integer>(list);
		Assertions.assertFalse(set2.size() > set.size(), "Some elements have been added");
		Assertions.assertFalse(set2.size() < set.size(), "Some elements have been removed");
		Assertions.assertEquals(set, set2, "Some elements have been modified");
	}
}
