package fr.upem.jacosa.safety;

public class BulbState
{
	private final boolean lighting;
	private final boolean faulty;
	
	public BulbState(boolean lighting, boolean faulty)
	{
		this.lighting = lighting;
		this.faulty = faulty;
	}
	
	public boolean isLighting() { return lighting; }
	public boolean isFaulty() { return faulty; }
	
	public static final BulbState SWITCHED_OFF = new BulbState(false, false);
	public static final BulbState SWITCHED_ON_FULL = new BulbState(true, false);
	public static final BulbState SWITCHED_ON_DIM = new BulbState(true, false);
	public static final BulbState WORN = new BulbState(false, true);
	public static final BulbState DISABLED = new BulbState(false, true);
}
