import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

public class PacketReceiver
{
	public static final int BUFFER_LENGTH = 1024;

	public static void main(String[] args) throws IOException
	{
		if (args.length < 3) throw new IllegalArgumentException("Not enough arguments");
		InetAddress a = InetAddress.getByName(args[0]);
		int port = Integer.parseInt(args[1]);
		int timeout = Integer.parseInt(args[2]);
		DatagramSocket s = new DatagramSocket(port, a);
		try {
			s.setSoTimeout(timeout);
			DatagramPacket p = new DatagramPacket(new byte[BUFFER_LENGTH], BUFFER_LENGTH);
			for (boolean go = true; go; )
			{
				try {
					s.receive(p);
				} catch (SocketTimeoutException e)
				{
					System.err.println("Sorry, no packet received before the timeout of " + timeout + " ms");
					go = false;
				}
				if (go)
				{
					System.out.println("Has received data from " + p.getAddress() + ":" + p.getPort());
					System.out.println(new String(p.getData(), 0, p.getLength(), "UTF-8"));
					p.setLength(BUFFER_LENGTH); // Reset the length to the size of the array
				}
			}
		} finally
		{
			s.close(); // Don't forget to liberate the socket resource
		}
	}
}
		
