package fr.upem.jacosa.net;

import java.net.*;
import java.io.*;
import java.util.*;

public class InterfaceTree
{
	public static void displayTree(NetworkInterface iface, PrintStream out) throws SocketException
	{
		Enumeration<NetworkInterface> ifaces = 
			(iface == null)?NetworkInterface.getNetworkInterfaces() // We get the root interfaces
			:iface.getSubInterfaces(); // or the child interfaces
		if (iface != null) 
		{
			out.println(iface.getName() + ":");
			Enumeration<InetAddress> addresses = iface.getInetAddresses();
			while (addresses.hasMoreElements())
				out.print(addresses.nextElement() + ",");
			out.print("(");
		}
		while (ifaces.hasMoreElements())
			displayTree(ifaces.nextElement(), out);
		if (iface != null) out.println(")");
	}

	public static void main(String[] args) throws SocketException
	{
		displayTree(null, System.out);
	}
}
