package fr.upem.jacosa.net;

import java.util.concurrent.*;

public class AsyncMax
{
	public static int computeMax(int[] tab, int start, int stop)
	{
		int max = Integer.MIN_VALUE;
		for (int i = start; i < stop; i++)
			if (tab[i] > max) max = tab[i];
		return max;
	}

	public static CompletableFuture<Integer> computeMax2(int[] tab)
	{
		CompletableFuture<Integer> stage1 = CompletableFuture.supplyAsync(() -> { return computeMax(tab, 0, tab.length / 2); });
		CompletableFuture<Integer> stage2 = CompletableFuture.supplyAsync(() -> { return computeMax(tab,tab.length/2+1, tab.length); });
		return stage1.thenCombine(stage2, (Integer max1, Integer max2) -> { return Math.max(max1, max2); });
	}

	public static void main(String[] args)
	{
		long start = System.nanoTime();
		int[] tab = new int[1000000];
		for (int i = 0; i < tab.length; i++)
			tab[i] = i;
		computeMax2(tab).thenAccept(v -> { System.out.println("Computed max: " + v + " in " + (System.nanoTime() - start)/10e9 + " s");});
	}
}