package fr.upem.jacosa.io;
import java.util.*;
import java.io.*;

// @run: WordLister
public class WordLister
{
	public static void main(String[] args) throws IOException
	{
		Scanner s = new Scanner(System.in);
		s.useDelimiter("[\\p{Punct}\\p{Space}]+");
		Map<String, Integer> occurrences = new TreeMap<>();
		while (s.hasNext())
		{
			String word = s.next();
			Integer i = occurrences.get(word);
			if (i == null) i = 0;
			occurrences.put(word, i+1);
		}
		for (Map.Entry<String, Integer> entry: occurrences.entrySet())
			System.out.println(entry.getKey() + ": " + entry.getValue());
	}
}
