package fr.upem.jacosa.io;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

/** Compute the average line length of a text file */
public class LineAverager
{
	public static float getAverageLineLength(Path path, Charset charset) throws IOException
	{
		try (BufferedReader r = Files.newBufferedReader(path, charset))
		{
			int count = 0, len = 0;
			for (String line = r.readLine(); line != null; line = r.readLine())
			{
				count++;			
				len += line.length();
			}
			return (float)len / (float)count;
		}
	}
	
	public static void main(String[] args) throws IOException
	{
		if (args.length < 2)
		{
			System.err.println("Usage: java LineAverager filepath charset");
			System.exit(-1);
		}
		Path path = Paths.get(args[0]);
		Charset charset = Charset.forName(args[1]);
		System.out.println(String.format("Average line length for %s: %f",
			path, getAverageLineLength(path, charset)));
	}
}
