package fr.upem.jacosa.io;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

/** Program determining the size of a fie by reading it */
public class FileSizer
{
	public static final int BUFFER_LEN = 1024;
	
	public static void main(String[] args) throws IOException
	{
		Path filepath = Paths.get(args[0]);
		System.out.println(String.format("Size of %s using getSize1: %l", filepath, getSize1(filepath)));
		System.out.println(String.format("Size of %s using getSize2: %l", filepath, getSize2(filepath)));
	}
	
	public static long getSize1(Path path) throws IOException
	{
		byte[] buffer = new byte[BUFFER_LEN];
		try (InputStream is = Files.newInputStream(path))
		{
			long size = 0;
			for (int i = is.read(buffer); i >= 0; i = is.read(buffer))
				size += i;
			return size;
		}
	}
	
	public static long getSize2(Path path) throws IOException
	{
		return Files.size(path);
	}
}
