package fr.upem.jacosa.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Names;

import java.util.Random;

public class HelloPrinterInjectionModule extends AbstractModule {
    private final HelloPrinterParams params;

    public HelloPrinterInjectionModule(HelloPrinterParams params) {
        super();
        this.params = params;
    }

    @Override
    protected void configure() {
        bind(MessageDisplayer.class).to(StdoutMessageDisplayer.class);
        bind(MessageDisplayer.class).annotatedWith(Names.named("stdout")).to(StdoutMessageDisplayer.class);
        bind(MessageDisplayer.class).annotatedWith(Names.named("stderr")).to(StderrMessageDisplayer.class);

        bind(String.class).annotatedWith(Names.named("name")).toInstance(params.name());
        bind(int.class).annotatedWith(Names.named("displayMinTimes")).toInstance(params.displayMinTimes());
        bind(int.class).annotatedWith(Names.named("displayMaxTimes")).toInstance(params.displayMaxTimes());
    }

    @Provides
    Random createRandom() {
        return new Random(1L);
    }
}
