package fr.upem.jacosa.general;

// @run: PolymorphismTester
public class PolymorphismTester
{
	static abstract public class Animal
	{
		protected void speak(Animal other, String message)
		{
			other.receive(this, message) ;
		}

		public void speak(Animal other)
		{
			speak(other, "default speech");
		}

		protected void receive(Animal sender, String message)
		{
			System.out.println(sender + " says to " + this + ": " + message) ;
		}
		
		public void run()
		{
			System.out.println("Running...");
		}
	}
	
	static class Cat extends Animal
	{
		public void speak(Animal other) { speak(other, "miaou") ; }
		public void speak(Human other) { speak(other, "miiiiaou") ; }
		public void speak(Dog other) { speak(other, "") ; run() ; }
	}
	
	static class Dog extends Animal
	{
		public void speak(Animal other) { speak(other, "ouaf") ; }
		public void speak(Human other) { speak(other, "ouaf ouaf") ; }
		public void speak(Cat other) { speak(other, "OUAF") ; run() ; }
	}
	
	static class Human extends Animal {}
	
	public static void main(String[] args)
	{
		Animal cat = new Cat() ;
		Cat cat2 = (Cat)cat ;
		Animal dog = new Dog() ;
		Human human = new Human() ;
		// we consider cat as an animal (that has only a method speak(Animal)
		cat.speak(human) ; // miaou
		cat.speak(dog) ; // miaou
		cat.speak((Dog)dog) ; // miaou
		// we consider cat2 as a cat (that has methods to speak with an animal, human and dog)
		cat2.speak(human) ; // miiiiaou
		cat2.speak(dog) ; // miaou
		cat2.speak((Dog)dog) ; // stay mute and run
		cat2.speak((Human)dog) ; // ClassCatException!
		// cat2.speak((Cat)human) ; // do not compile (statically detected cast error) !
	}
}

	
	