package fr.upem.jacosa.general;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

// @run: MapFactory
public class MapFactory
{
	private boolean sorted ;

	void setSorted(boolean sorted)
	{
		this.sorted = sorted ;
	}

	public <K, V> Map<K, V> create()
	{
		if (sorted)
			return new TreeMap<K, V>();
		else
			return new HashMap<K, V>();
	}
	
	/** We test the factory */
	public static void main(String[] args)
	{
		MapFactory mf = new MapFactory();
		Map<Integer, Integer> m1 = mf.create(); // Création d'une HashMap
		System.out.println(m1.getClass()); // should print HashMap
		mf.setSorted(true);
		Map<Integer, Integer> m2 = mf.create(); // Création d'une SortedMap
		System.out.println(m2.getClass()); // should print TreeMap
	}
}