package fr.upem.jacosa.general;

// @run FrenchCarPlate 1500
/** A registration plate from a French car */
public final class FrenchCarPlate
{
	private static FrenchCarPlate nextPlate = new FrenchCarPlate("AA", 1, "AA");
	
	private static String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	
	private final String prefix;
	private final int number;
	private final String suffix;
	
	private FrenchCarPlate(String prefix, int number, String suffix)
	{
		this.prefix = prefix;
		this.number = number;
		this.suffix = suffix;
	}
	
	public String toString()
	{
		return String.format("%s-%03d-%s", prefix, number, suffix);
	}
	
	private static String findNextLetters(String s)
	{
		char letter1 = s.charAt(0);
		char letter2 = s.charAt(1);
		int pos1 = LETTERS.indexOf(letter1);
		int pos2 = LETTERS.indexOf(letter2);
		if (pos2 < LETTERS.length()-1)
			pos2++;
		else if (pos1 < LETTERS.length()-1) {
			pos2 = 0;
			pos1++;
		} else
			return null; // cannot find a successor for ZZ
		return "" + LETTERS.charAt(pos1) + LETTERS.charAt(pos2);
	}
	
	/** Get the plate following a given plate */
	private FrenchCarPlate getNextPlate()
	{
		String newPrefix = prefix;
		String newSuffix = suffix;
		int newNumber = number + 1;
		if (newNumber == 1000)
		{
			newNumber = 1;
			newSuffix = findNextLetters(suffix);
			if (newSuffix == null) 
			{
				newSuffix = "AA";
				newPrefix = findNextLetters(prefix);
				if (newPrefix == null) newPrefix = "AA"; // we cycle
			}
		}
		return new FrenchCarPlate(newPrefix, newNumber, newSuffix);
	}
	
	public static FrenchCarPlate createNewPlate()
	{
		try {
			return nextPlate;
		} finally {
			nextPlate = nextPlate.getNextPlate();
		}
	}
	
	public static void main(String[] args)
	{
		int n = Integer.parseInt(args[0]);
		for (int k = 0; k < n; k++)
			System.out.println(createNewPlate());
	}
}

