package fr.upem.jacosa.general;

/** A class testing the finalize method */
// @run: Finalizer 3000
public class Finalizer
{
	/** Keep the number of instances of the class */
	private static int INSTANCES = 0;
	
	public Finalizer()
	{
		INSTANCES++; // we initialize a new instance
	}
    
    public static int getInstanceNumber()
    {
		return INSTANCES;
	}
	
	/** This method is called before the destruction of the object by the garbage collector */
	protected void finalize() throws Throwable
	{
		super.finalize();
		INSTANCES--;
	}
	
	/** Let's test the class */
	public static void main(String[] args) throws Exception
	{
		int sleepTime = Integer.parseInt(args[0]); // sleep time is in args[0] in milliseconds
		Finalizer[] finalizers = new Finalizer[2];
		System.out.println(getInstanceNumber()); // should print 0
		finalizers[0] = new Finalizer();
		System.out.println(getInstanceNumber()); // should print 1
		finalizers[1] = new Finalizer();
		System.out.println(getInstanceNumber()); // should print 2
		finalizers = null; // the array is not reachable now (and transitively the finalizers)
		System.gc();
		Thread.sleep(sleepTime);
		System.out.println(getInstanceNumber()); // has the garbage collector destroyed the finalizers?
	}
}
