package fr.upem.jacosa.general;

import java.util.ArrayList;
import java.util.List;

// @run: FiboSequence

/** A Fibonacci sequence computer */
public class FiboSequence
{
	private static FiboSequence defaultInstance;
	
	/** Return the default instance (and create it if required for the first time */
	public static FiboSequence getDefaultInstance()
	{
		if (defaultInstance == null)
			defaultInstance = new FiboSequence(1, 1);
		return defaultInstance;
	}
	
	private final List<Long> fiboList =
		new ArrayList<Long>();
		
	/** Build the FiboSequence object, 
	  * note that the constructor is private 
	  */
	private FiboSequence(long first, long second)
	{
		fiboList.add(first);
		fiboList.add(second);
	}
		
	/** Compute the n-th number of Fibonacci */
	public long getValue(int rank)
	{
		// first, compute the missing numbers
		while (rank >= fiboList.size())
		{
			int n = fiboList.size();
			fiboList.add(fiboList.get(n-1) + fiboList.get(n-2));
		}
		return fiboList.get(rank);
	}
	
	/** Main method to compute the Fibonacci sequence term whose index is passed as args[0] */
	public static void main(String[] args)
	{
		int rank = Integer.parseInt(args[0]);
		System.out.println(getDefaultInstance().getValue(rank));
	}
}
