package fr.upem.jacosa.collections;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/** Gather strings by the number of vowel they contain */
public class VowelGrouper 
{
	public static final String VOWELS = "aeiouy";
	
	public static int getVowelNumber(String s)
	{
		return (int)s.chars().filter(x -> VOWELS.indexOf(x) >= 0 ).count();
	}
	
	public static Map<Integer, List<String>> groupByVowelNumber(Stream<String> stream)
	{
		return stream.collect(Collectors.groupingBy(x -> getVowelNumber(x)));
	}
	
	public static void main(String[] args)
	{
		System.out.println(groupByVowelNumber(Arrays.asList(args).stream()));
	}
}
