package fr.upem.jacosa.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;


public class SetTest
{
	static class TestObject implements Comparable<TestObject>
	{
		@Override
		public int hashCode()
		{
			final int prime = 31;
			int result = 1;
			result = prime * result + value;
			return result;
		}

		@Override
		public boolean equals(Object obj)
		{
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			TestObject other = (TestObject) obj;
			if (value != other.value)
				return false;
			return true;
		}

		int value;
		
		public TestObject(int value)
		{
			this.value = value;
		}

		@Override
		public int compareTo(TestObject o)
		{
			if (o == null) return 1;
			if (value < o.value) return -1;
			else if (value > o.value) return 1;
			else return 0;
		}
	}
	
	/** Launch a sequence of tests on a collection by adding, 
	 * testing the presence and removing elements
	 */
	public static long test(Collection<TestObject> coll, int N)
	{
		long start = System.nanoTime();
		for (int i = 0; i < N; i++)
			coll.add(new TestObject(i));
		for (int i = 0; i < N; i++)
			if (! coll.contains(new TestObject(i)))
				throw new RuntimeException("The element " + i + " is not present");
		for (int i = 0; i < N; i++)
			coll.remove(new TestObject(i));
		return (System.nanoTime() - start)/1000000;
	}
	
	public static void main(String[] args)
	{
		for (int i = 0; i < 2000000; i += 500)
		{
			System.out.println(String.format("%d\t%d\t%d",
				i,
				test(new HashSet<TestObject>(), i),
				test(new TreeSet<TestObject>(), i)
				/*test(new LinkedList<TestObject>(), i), */
				/*test(new ArrayList<TestObject>(), i) */));
		}
	}
}
