package fr.upem.jacosa.collections;

import java.util.function.Supplier;
import java.util.stream.Stream;

public class PrimeStream
{
	public static Stream<Long> getCandidateDividerStream(final long n)
	{
		Supplier<Long> supplier = new Supplier<Long>() {
			long i = 2;
			
			public Long get() { return i++; }
		};
		return Stream.generate(supplier)
			.filter( x -> x % 2 == 1 || x == 2 ) // select only odd elements (and also 2)
			.takeWhile(x -> x * x <= n); // takeWhile is available with Java 1.9
	}
	
	public static boolean isPrime(final long n)
	{
		return getCandidateDividerStream(n).noneMatch( x -> n % x == 0 );
	}
	
	/** Return the number of primes below a given limit */
	public static long getPrimeNumber(final long limit)
	{
		return Stream.concat(
			Stream.of(2L), 
			Stream.iterate(3L, x -> x + 2L))
				.takeWhile( x -> x <= limit)
				.filter( x -> isPrime(x) )
				.count();
	}
	
	public static void main(String[] args)
	{
		long n = Long.parseLong(args[0]);
		System.out.println("Number of primes below " + n + ": " + getPrimeNumber(n));
	}
}
